/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;
import org.jetbrains.kotlin.utils.LibraryUtils;

class JpsUtils {
    private JpsUtils() {
    }

    @NotNull
    static JpsJavaDependenciesEnumerator getAllDependencies(@NotNull ModuleBuildTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/jps/build/JpsUtils", "getAllDependencies"));
        }
        JpsJavaDependenciesEnumerator jpsJavaDependenciesEnumerator = JpsJavaExtensionService.dependencies((JpsModule)target.getModule()).recursively().exportedOnly().includedIn(JpsJavaClasspathKind.compile((boolean)target.isTests()));
        if (jpsJavaDependenciesEnumerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/jps/build/JpsUtils", "getAllDependencies"));
        }
        return jpsJavaDependenciesEnumerator;
    }

    static boolean isJsKotlinModule(@NotNull ModuleBuildTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/jps/build/JpsUtils", "isJsKotlinModule"));
        }
        Set libraries = JpsUtils.getAllDependencies(target).getLibraries();
        for (JpsLibrary library : libraries) {
            for (JpsLibraryRoot root : library.getRoots(JpsOrderRootType.COMPILED)) {
                if (!LibraryUtils.isKotlinJavascriptStdLibrary(JpsPathUtil.urlToFile((String)root.getUrl()))) continue;
                return true;
            }
        }
        return false;
    }
}

