/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.tmatesoft.svn.core.SVNURL;

public class WCInfo {
    private final boolean myIsWcRoot;
    @NotNull
    private final Depth myStickyDepth;
    @NotNull
    private final RootUrlInfo myRootInfo;

    public WCInfo(@NotNull RootUrlInfo rootInfo, boolean isWcRoot, @NotNull Depth stickyDepth) {
        if (rootInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootInfo", "org/jetbrains/idea/svn/dialogs/WCInfo", "<init>"));
        }
        if (stickyDepth == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stickyDepth", "org/jetbrains/idea/svn/dialogs/WCInfo", "<init>"));
        }
        this.myRootInfo = rootInfo;
        this.myIsWcRoot = isWcRoot;
        this.myStickyDepth = stickyDepth;
    }

    @NotNull
    public Depth getStickyDepth() {
        Depth depth = this.myStickyDepth;
        if (depth == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/WCInfo", "getStickyDepth"));
        }
        return depth;
    }

    @NotNull
    public String getPath() {
        String string = this.myRootInfo.getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/WCInfo", "getPath"));
        }
        return string;
    }

    @Nullable
    public VirtualFile getVcsRoot() {
        return null;
    }

    @NotNull
    public SVNURL getUrl() {
        SVNURL sVNURL = this.myRootInfo.getAbsoluteUrlAsUrl();
        if (sVNURL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/WCInfo", "getUrl"));
        }
        return sVNURL;
    }

    @NotNull
    public String getRootUrl() {
        String string = this.getUrl().toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/WCInfo", "getRootUrl"));
        }
        return string;
    }

    @NotNull
    public String getRepoUrl() {
        String string = this.getRepositoryRoot();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/WCInfo", "getRepoUrl"));
        }
        return string;
    }

    @NotNull
    public RootUrlInfo getRootInfo() {
        RootUrlInfo rootUrlInfo = this.myRootInfo;
        if (rootUrlInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/WCInfo", "getRootInfo"));
        }
        return rootUrlInfo;
    }

    public boolean hasError() {
        return this.getRootInfo().getNode().hasError();
    }

    @NotNull
    public String getErrorMessage() {
        SvnBindException error = this.getRootInfo().getNode().getError();
        String string = error != null ? error.getMessage() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/WCInfo", "getErrorMessage"));
        }
        return string;
    }

    @NotNull
    public WorkingCopyFormat getFormat() {
        WorkingCopyFormat workingCopyFormat = this.myRootInfo.getFormat();
        if (workingCopyFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/WCInfo", "getFormat"));
        }
        return workingCopyFormat;
    }

    @NotNull
    public String getRepositoryRoot() {
        String string = this.myRootInfo.getRepositoryUrl();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/WCInfo", "getRepositoryRoot"));
        }
        return string;
    }

    public boolean isIsWcRoot() {
        return this.myIsWcRoot;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WCInfo)) {
            return false;
        }
        WCInfo wcInfo = (WCInfo)o;
        return this.getPath().equals(wcInfo.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    @Nullable
    public NestedCopyType getType() {
        return this.myRootInfo.getType();
    }
}

