/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.diff;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.vcsUtil.VcsUtil;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.io.SVNRepository;

public class DiffContentRevision
implements ByteBackedContentRevision {
    private String myPath;
    private SVNRepository myRepository;
    private byte[] myContents;
    private FilePath myFilePath;
    private long myRevision;

    public DiffContentRevision(String path, @NotNull SVNRepository repos, long revision) {
        if (repos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repos", "org/jetbrains/idea/svn/diff/DiffContentRevision", "<init>"));
        }
        this(path, repos, revision, VcsUtil.getFilePath((String)path));
    }

    public DiffContentRevision(String path, SVNRepository repository, long revision, FilePath filePath) {
        this.myPath = path;
        this.myRepository = repository;
        this.myFilePath = filePath;
        this.myRevision = revision;
    }

    @NotNull
    public String getContent() throws VcsException {
        byte[] bytes = this.getContentAsBytes();
        Charset charset = this.myFilePath.getCharset();
        String string = CharsetToolkit.bytesToString((byte[])bytes, (Charset)charset);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/diff/DiffContentRevision", "getContent"));
        }
        return string;
    }

    @NotNull
    public byte[] getContentAsBytes() throws VcsException {
        if (this.myContents == null) {
            BufferExposingByteArrayOutputStream bos = new BufferExposingByteArrayOutputStream(2048);
            try {
                this.myRepository.getFile(this.myPath, -1L, null, (OutputStream)bos);
                this.myRepository.closeSession();
            }
            catch (SVNException e) {
                throw new VcsException((Throwable)e);
            }
            this.myContents = bos.toByteArray();
        }
        if (this.myContents == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/diff/DiffContentRevision", "getContentAsBytes"));
        }
        return this.myContents;
    }

    @NotNull
    public FilePath getFile() {
        FilePath filePath = this.myFilePath;
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/diff/DiffContentRevision", "getFile"));
        }
        return filePath;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        VcsRevisionNumber.Long longVal = new VcsRevisionNumber.Long(this.myRevision);
        if (longVal == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/diff/DiffContentRevision", "getRevisionNumber"));
        }
        return longVal;
    }
}

