/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.svnkit.lowLevel;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.hash.HashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.idea.svn.svnkit.lowLevel.ApplicationLevelNumberConnectionsGuard;
import org.jetbrains.idea.svn.svnkit.lowLevel.SvnRepositoryPool;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.SVNRepository;

public class CachingSvnRepositoryPool
implements SvnRepositoryPool {
    private static final long DEFAULT_IDLE_TIMEOUT = 60000L;
    private static final int ourMaxCachedDefault = 5;
    private static final int ourMaxConcurrentDefault = 20;
    static final int ourMaxTotal = 100;
    private final int myMaxCached;
    private int myMaxConcurrent;
    private final ThrowableConvertor<SVNURL, SVNRepository, SVNException> myCreator;
    private final ThrowableConsumer<Pair<SVNURL, SVNRepository>, SVNException> myAdjuster;
    private final Map<String, RepoGroup> myGroups;
    private ApplicationLevelNumberConnectionsGuard myGuard;
    private long myConnectionTimeout;
    private boolean myDisposed;
    private final Object myLock;

    public CachingSvnRepositoryPool(ThrowableConvertor<SVNURL, SVNRepository, SVNException> creator, int maxCached, int maxConcurrent, ThrowableConsumer<Pair<SVNURL, SVNRepository>, SVNException> adjuster, ApplicationLevelNumberConnectionsGuard guard) {
        this.myGuard = guard;
        this.myLock = new Object();
        this.myConnectionTimeout = 60000L;
        this.myCreator = creator;
        this.myAdjuster = adjuster;
        this.myMaxCached = maxCached > 0 ? maxCached : 5;
        int n = this.myMaxConcurrent = maxConcurrent > 0 ? maxConcurrent : 20;
        if (this.myMaxConcurrent < this.myMaxCached) {
            this.myMaxConcurrent = this.myMaxCached;
        }
        this.myGroups = new HashMap<String, RepoGroup>();
        this.myDisposed = false;
    }

    public CachingSvnRepositoryPool(ThrowableConvertor<SVNURL, SVNRepository, SVNException> creator, ThrowableConsumer<Pair<SVNURL, SVNRepository>, SVNException> adjuster, ApplicationLevelNumberConnectionsGuard guard) {
        this(creator, -1, -1, adjuster, guard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionTimeout(long connectionTimeout) {
        Object object = this.myLock;
        synchronized (object) {
            this.myConnectionTimeout = connectionTimeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitingInterrupted() {
        Object object = this.myLock;
        synchronized (object) {
            for (RepoGroup group : this.myGroups.values()) {
                group.interruptWaiting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myDisposed) {
                return;
            }
            for (RepoGroup group : this.myGroups.values()) {
                group.recheck();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNRepository getRepo(SVNURL url, boolean mayReuse) throws SVNException {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myDisposed) {
                throw new ProcessCanceledException();
            }
            String host = url.getHost();
            RepoGroup group = this.myGroups.get(host);
            if (group == null) {
                group = new RepoGroup(this.myCreator, this.myMaxCached, this.myMaxConcurrent, this.myAdjuster, this.myGuard, this.myLock, this.myConnectionTimeout);
            }
            this.myGroups.put(host, group);
            return group.getRepo(url, mayReuse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnRepo(SVNRepository repo) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myDisposed) {
                repo.closeSession();
                this.myGuard.connectionDestroyed(1);
                return;
            }
            String host = repo.getLocation().getHost();
            RepoGroup group = this.myGroups.get(host);
            assert (group != null);
            group.returnRepo(repo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            this.myDisposed = true;
            for (RepoGroup group : this.myGroups.values()) {
                group.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeInactive() {
        Object object = this.myLock;
        synchronized (object) {
            for (RepoGroup group : this.myGroups.values()) {
                group.closeInactive();
            }
        }
    }

    public Map<String, RepoGroup> getGroups() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        return this.myGroups;
    }

    public static class RepoGroup
    implements SvnRepositoryPool {
        private final ThrowableConvertor<SVNURL, SVNRepository, SVNException> myCreator;
        private final int myMaxCached;
        private final int myMaxConcurrent;
        private final ThrowableConsumer<Pair<SVNURL, SVNRepository>, SVNException> myAdjuster;
        private final ApplicationLevelNumberConnectionsGuard myGuard;
        private final TreeMap<Long, SVNRepository> myInactive;
        private final Set<SVNRepository> myUsed;
        private boolean myDisposed;
        private final Object myWait;
        private long myConnectionTimeout;

        private RepoGroup(ThrowableConvertor<SVNURL, SVNRepository, SVNException> creator, int cached, int concurrent, ThrowableConsumer<Pair<SVNURL, SVNRepository>, SVNException> adjuster, ApplicationLevelNumberConnectionsGuard guard, Object waitObj, long connectionTimeout) {
            this.myCreator = creator;
            this.myMaxCached = cached;
            this.myMaxConcurrent = concurrent;
            this.myAdjuster = adjuster;
            this.myGuard = guard;
            this.myConnectionTimeout = connectionTimeout;
            this.myInactive = new TreeMap();
            this.myUsed = new HashSet();
            this.myDisposed = false;
            this.myWait = waitObj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            final ArrayList<SVNRepository> listForClose = new ArrayList<SVNRepository>();
            listForClose.addAll(this.myInactive.values());
            this.myInactive.clear();
            this.myUsed.clear();
            Object object = this.myWait;
            synchronized (object) {
                this.myWait.notifyAll();
            }
            this.myDisposed = true;
            this.myWait.notifyAll();
            this.myGuard.connectionDestroyed(listForClose.size());
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    for (SVNRepository repository : listForClose) {
                        repository.closeSession();
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void interruptWaiting() {
            Object object = this.myWait;
            synchronized (object) {
                this.myWait.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SVNRepository getRepo(SVNURL url, boolean mayReuse) throws SVNException {
            if (this.myDisposed) {
                return null;
            }
            if (!this.myInactive.isEmpty() && mayReuse) {
                return this.fromInactive(url);
            }
            this.myGuard.waitForTotalNumberOfConnectionsOk();
            if (this.myUsed.size() >= this.myMaxConcurrent) {
                Object object = this.myWait;
                synchronized (object) {
                    if (this.myUsed.size() + this.myInactive.size() >= this.myMaxConcurrent) {
                        while (this.myUsed.size() + this.myInactive.size() >= this.myMaxConcurrent && !this.myDisposed) {
                            ProgressIndicator indicator;
                            try {
                                this.myWait.wait(300L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if ((indicator = ProgressManager.getInstance().getProgressIndicator()) == null || !indicator.isCanceled()) continue;
                            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CANCELLED));
                        }
                        if (this.myDisposed) {
                            this.myWait.notifyAll();
                            throw new ProcessCanceledException();
                        }
                    }
                }
            }
            if (!this.myInactive.isEmpty() && mayReuse) {
                return this.fromInactive(url);
            }
            assert (this.myUsed.size() <= this.myMaxConcurrent);
            SVNRepository fun = (SVNRepository)this.myCreator.convert((Object)url);
            this.myUsed.add(fun);
            this.myGuard.connectionCreated();
            return fun;
        }

        private SVNRepository fromInactive(SVNURL url) throws SVNException {
            Map.Entry<Long, SVNRepository> entry = this.myInactive.firstEntry();
            SVNRepository next = entry.getValue();
            this.myInactive.remove(entry.getKey());
            this.myAdjuster.consume((Object)Pair.create((Object)url, (Object)next));
            if (!this.myGuard.shouldKeepConnectionLocally()) {
                this.myInactive.clear();
            }
            return next;
        }

        @Override
        public void returnRepo(SVNRepository repo) {
            this.myUsed.remove(repo);
            if (this.myGuard.shouldKeepConnectionLocally() && this.myInactive.size() < this.myMaxCached) {
                long time = System.currentTimeMillis();
                if (this.myInactive.containsKey(time)) {
                    time = this.myInactive.lastKey() + 1L;
                }
                this.myInactive.put(time, repo);
            } else {
                repo.closeSession();
                this.myGuard.connectionDestroyed(1);
            }
        }

        public void recheck() {
            Long next;
            long time = System.currentTimeMillis();
            Set<Long> longs = this.myInactive.keySet();
            Iterator<Long> iterator = longs.iterator();
            while (iterator.hasNext() && time - (next = iterator.next()) > this.myConnectionTimeout) {
                this.myInactive.get(next).closeSession();
                this.myGuard.connectionDestroyed(1);
                iterator.remove();
            }
        }

        public int closeInactive() {
            int cnt = this.myInactive.size();
            for (SVNRepository repository : this.myInactive.values()) {
                repository.closeSession();
                this.myGuard.connectionDestroyed(1);
            }
            this.myInactive.clear();
            return cnt;
        }

        public int getUsedSize() {
            return this.myUsed.size();
        }

        public int getInactiveSize() {
            return this.myInactive.size();
        }
    }
}

