/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.descriptors;

import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SystemImage;
import com.android.sdklib.io.FileOp;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.License;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.NoPreviewRevision;
import com.android.sdklib.repository.PreciseRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.IPkgDescAddon;
import com.android.sdklib.repository.descriptors.IPkgDescExtra;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.descriptors.PkgDescAddon;
import com.android.sdklib.repository.descriptors.PkgDescExtra;
import com.android.sdklib.repository.descriptors.PkgType;
import java.io.File;
import java.util.Locale;

public class PkgDesc
implements IPkgDesc {
    public static final String PREVIEW_SUFFIX = "-preview";
    private final PkgType mType;
    private final FullRevision mFullRevision;
    private final MajorRevision mMajorRevision;
    private final AndroidVersion mAndroidVersion;
    private final String mPath;
    private final IdDisplay mTag;
    private final IdDisplay mVendor;
    private final FullRevision mMinToolsRev;
    private final FullRevision mMinPlatformToolsRev;
    private final IIsUpdateFor mCustomIsUpdateFor;
    private final IGetPath mCustomPath;
    private final License mLicense;
    private final String mListDisplay;
    private final String mDescriptionShort;
    private final String mDescriptionUrl;
    private final boolean mIsObsolete;

    protected PkgDesc(PkgType type, License license, String listDisplay, String descriptionShort, String descriptionUrl, boolean isObsolete, FullRevision fullRevision, MajorRevision majorRevision, AndroidVersion androidVersion, String path, IdDisplay tag, IdDisplay vendor, FullRevision minToolsRev, FullRevision minPlatformToolsRev, IIsUpdateFor customIsUpdateFor, IGetPath customPath) {
        this.mType = type;
        this.mIsObsolete = isObsolete;
        this.mLicense = license;
        this.mListDisplay = listDisplay;
        this.mDescriptionShort = descriptionShort;
        this.mDescriptionUrl = descriptionUrl;
        this.mFullRevision = fullRevision;
        this.mMajorRevision = majorRevision;
        this.mAndroidVersion = androidVersion;
        this.mPath = path;
        this.mTag = tag;
        this.mVendor = vendor;
        this.mMinToolsRev = minToolsRev;
        this.mMinPlatformToolsRev = minPlatformToolsRev;
        this.mCustomIsUpdateFor = customIsUpdateFor;
        this.mCustomPath = customPath;
    }

    @Override
    public PkgType getType() {
        return this.mType;
    }

    @Override
    public String getListDisplay() {
        return this.mListDisplay;
    }

    @Override
    public String getDescriptionShort() {
        return this.mDescriptionShort;
    }

    @Override
    public String getDescriptionUrl() {
        return this.mDescriptionUrl;
    }

    @Override
    public License getLicense() {
        return this.mLicense;
    }

    @Override
    public boolean isObsolete() {
        return this.mIsObsolete;
    }

    @Override
    public final boolean hasFullRevision() {
        return this.getType().hasFullRevision();
    }

    @Override
    public final boolean hasMajorRevision() {
        return this.getType().hasMajorRevision();
    }

    @Override
    public final boolean hasAndroidVersion() {
        return this.getType().hasAndroidVersion();
    }

    @Override
    public final boolean hasPath() {
        return this.getType().hasPath();
    }

    @Override
    public final boolean hasTag() {
        return this.getType().hasTag();
    }

    @Override
    public boolean hasVendor() {
        return this.getType().hasVendor();
    }

    @Override
    public final boolean hasMinToolsRev() {
        return this.getType().hasMinToolsRev();
    }

    @Override
    public final boolean hasMinPlatformToolsRev() {
        return this.getType().hasMinPlatformToolsRev();
    }

    @Override
    public FullRevision getFullRevision() {
        return this.mFullRevision;
    }

    @Override
    public MajorRevision getMajorRevision() {
        return this.mMajorRevision;
    }

    @Override
    public final PreciseRevision getPreciseRevision() {
        if (this.mMajorRevision == null) {
            return new PreciseRevision(this.mFullRevision.getMajor(), this.mFullRevision.getMinor(), this.mFullRevision.getMicro(), this.mFullRevision.getPreview());
        }
        return new PreciseRevision(this.mMajorRevision.getMajor());
    }

    @Override
    public AndroidVersion getAndroidVersion() {
        return this.mAndroidVersion;
    }

    @Override
    public boolean isPreview() {
        return this.getPreciseRevision().isPreview();
    }

    @Override
    public String getPath() {
        if (this.mCustomPath != null) {
            return this.mCustomPath.getPath(this);
        }
        return this.mPath;
    }

    @Override
    public IdDisplay getTag() {
        return this.mTag;
    }

    @Override
    public IdDisplay getVendor() {
        return this.mVendor;
    }

    @Override
    public FullRevision getMinToolsRev() {
        return this.mMinToolsRev;
    }

    @Override
    public FullRevision getMinPlatformToolsRev() {
        return this.mMinPlatformToolsRev;
    }

    @Override
    public String getInstallId() {
        String id = this.getBaseInstallId();
        if (this.getPreciseRevision().isPreview()) {
            return id + PREVIEW_SUFFIX;
        }
        return id;
    }

    @Override
    public String getBaseInstallId() {
        StringBuilder sb = new StringBuilder();
        switch (this.mType) {
            case PKG_TOOLS: 
            case PKG_PLATFORM_TOOLS: {
                sb.append(this.mType.getFolderName());
                break;
            }
            case PKG_BUILD_TOOLS: {
                sb.append(this.mType.getFolderName()).append('-');
                int[] version = this.getPreciseRevision().toIntArray(false);
                for (int i = 0; i < version.length; ++i) {
                    sb.append(version[i]);
                    if (i == version.length - 1) continue;
                    sb.append('.');
                }
                break;
            }
            case PKG_DOC: {
                sb.append("doc");
                break;
            }
            case PKG_SAMPLE: 
            case PKG_SOURCE: {
                sb.append(this.mType.toString().toLowerCase(Locale.US).replace("pkg_", ""));
                sb.append('-').append(this.getAndroidVersion().getApiString());
                break;
            }
            case PKG_EXTRA: {
                sb.append("extra-").append(this.getVendor().getId()).append('-').append(this.getPath());
                break;
            }
            case PKG_PLATFORM: {
                sb.append("android-").append(this.getAndroidVersion().getApiString());
                break;
            }
            case PKG_ADDON: {
                sb.append("addon-").append(((IPkgDescAddon)((Object)this)).getName().getId()).append('-').append(this.getVendor().getId()).append('-').append(this.getAndroidVersion().getApiString());
                break;
            }
            case PKG_SYS_IMAGE: {
                sb.append("sys-img-").append(this.getPath()).append('-').append(SystemImage.DEFAULT_TAG.equals(this.getTag()) ? "android" : this.getTag().getId()).append('-').append(this.getAndroidVersion().getApiString());
                break;
            }
            case PKG_ADDON_SYS_IMAGE: {
                sb.append("sys-img-").append(this.getPath()).append("-addon-").append(SystemImage.DEFAULT_TAG.equals(this.getTag()) ? "android" : this.getTag().getId()).append('-').append(this.getVendor().getId()).append('-').append(this.getAndroidVersion().getApiString());
                break;
            }
            case PKG_NDK: {
                sb.append("ndk");
                break;
            }
            case PKG_LLDB: {
                sb.append("lldb");
                break;
            }
            default: {
                throw new IllegalArgumentException("IID not defined for type " + this.mType.toString());
            }
        }
        return PkgDesc.sanitize(sb.toString());
    }

    @Override
    public File getCanonicalInstallFolder(File sdkLocation) {
        File f = FileOp.append(sdkLocation, this.mType.getFolderName());
        switch (this.mType) {
            case PKG_TOOLS: 
            case PKG_PLATFORM_TOOLS: 
            case PKG_DOC: {
                break;
            }
            case PKG_BUILD_TOOLS: 
            case PKG_ADDON: {
                f = FileOp.append(f, this.getInstallId());
                break;
            }
            case PKG_SAMPLE: 
            case PKG_SOURCE: 
            case PKG_PLATFORM: {
                f = FileOp.append(f, "android-" + PkgDesc.sanitize(this.getAndroidVersion().getApiString()));
                break;
            }
            case PKG_SYS_IMAGE: {
                f = FileOp.append(f, "android-" + PkgDesc.sanitize(this.getAndroidVersion().getApiString()), PkgDesc.sanitize(SystemImage.DEFAULT_TAG.equals(this.getTag()) ? "android" : this.getTag().getId()), PkgDesc.sanitize(this.getPath()));
                break;
            }
            case PKG_ADDON_SYS_IMAGE: {
                String name = "addon-" + (SystemImage.DEFAULT_TAG.equals(this.getTag()) ? "android" : this.getTag().getId()) + '-' + this.getVendor().getId() + '-' + this.getAndroidVersion().getApiString();
                f = FileOp.append(f, PkgDesc.sanitize(name), PkgDesc.sanitize(this.getPath()));
                break;
            }
            case PKG_EXTRA: {
                f = FileOp.append(f, PkgDesc.sanitize(this.getVendor().getId()), PkgDesc.sanitize(this.getPath()));
                break;
            }
            default: {
                throw new IllegalArgumentException("CanonicalFolder not defined for type " + this.mType.toString());
            }
        }
        return f;
    }

    @Override
    public boolean isUpdateFor(IPkgDesc existingDesc) {
        return this.isUpdateFor(existingDesc, FullRevision.PreviewComparison.COMPARE_NUMBER);
    }

    @Override
    public boolean isUpdateFor(IPkgDesc existingDesc, FullRevision.PreviewComparison previewComparison) {
        if (this.mCustomIsUpdateFor != null) {
            return this.mCustomIsUpdateFor.isUpdateFor(this, existingDesc);
        }
        return this.isGenericUpdateFor(existingDesc, previewComparison);
    }

    private boolean isGenericUpdateFor(IPkgDesc existingDesc, FullRevision.PreviewComparison previewComparison) {
        if (existingDesc == null || !this.getType().equals(existingDesc.getType())) {
            return false;
        }
        if (this.hasAndroidVersion() && !this.getAndroidVersion().equals(existingDesc.getAndroidVersion())) {
            return false;
        }
        if (this.hasVendor() && !this.getVendor().equals(existingDesc.getVendor())) {
            return false;
        }
        if (this.hasTag() && !this.getTag().getId().equals(existingDesc.getTag().getId())) {
            return false;
        }
        if (this.hasPath() && (this instanceof IPkgDescExtra ? !PkgDescExtra.compatibleVendorAndPath((IPkgDescExtra)((Object)this), (IPkgDescExtra)existingDesc) : !this.getPath().equals(existingDesc.getPath()))) {
            return false;
        }
        if (this.hasMajorRevision() && this.getMajorRevision().compareTo(existingDesc.getMajorRevision()) > 0) {
            return true;
        }
        if (this.hasFullRevision() && (previewComparison == FullRevision.PreviewComparison.IGNORE || existingDesc.isPreview() == this.isPreview())) {
            return this.getFullRevision().compareTo(existingDesc.getFullRevision(), FullRevision.PreviewComparison.COMPARE_NUMBER) > 0;
        }
        return false;
    }

    @Override
    public int compareTo(IPkgDesc o) {
        int t2;
        int t1 = this.getType().getIntValue();
        if (t1 != (t2 = o.getType().getIntValue())) {
            return t1 - t2;
        }
        if (this.hasAndroidVersion() && o.hasAndroidVersion() && (t1 = this.getAndroidVersion().compareTo(o.getAndroidVersion())) != 0) {
            return t1;
        }
        if (this.hasVendor() && o.hasVendor() && (t1 = this.getVendor().compareTo(o.getVendor())) != 0) {
            return t1;
        }
        if (this.hasTag() && o.hasTag() && (t1 = this.getTag().compareTo(o.getTag())) != 0) {
            return t1;
        }
        if (this.hasPath() && o.hasPath() && (t1 = this.getPath().compareTo(o.getPath())) != 0) {
            return t1;
        }
        if (this.hasFullRevision() && o.hasFullRevision() && (t1 = this.getFullRevision().compareTo(o.getFullRevision())) != 0) {
            return t1;
        }
        if (this.hasMajorRevision() && o.hasMajorRevision() && (t1 = this.getMajorRevision().compareTo(o.getMajorRevision())) != 0) {
            return t1;
        }
        if (this.hasMinToolsRev() && o.hasMinToolsRev() && (t1 = this.getMinToolsRev().compareTo(o.getMinToolsRev())) != 0) {
            return t1;
        }
        if (this.hasMinPlatformToolsRev() && o.hasMinPlatformToolsRev() && (t1 = this.getMinPlatformToolsRev().compareTo(o.getMinPlatformToolsRev())) != 0) {
            return t1;
        }
        return 0;
    }

    @Override
    public String getListDescription() {
        if (this.mListDisplay != null && !this.mListDisplay.isEmpty()) {
            return this.mListDisplay;
        }
        return this.patternReplaceImpl(this.getType().getListDisplayPattern());
    }

    protected String patternReplaceImpl(String result) {
        int end;
        result = result.replace("$MAJ", this.hasMajorRevision() ? this.getMajorRevision().toShortString() : "");
        result = result.replace("$FULL", this.hasFullRevision() ? this.getFullRevision().toShortString() : "");
        result = result.replace("$API", this.hasAndroidVersion() ? this.getAndroidVersion().getApiString() : "");
        result = result.replace("$PATH", this.hasPath() ? this.getPath() : "");
        result = result.replace("$TAG", this.hasTag() && !this.getTag().equals(SystemImage.DEFAULT_TAG) ? this.getTag().getDisplay() : "");
        result = result.replace("$VEND", this.hasVendor() ? this.getVendor().getDisplay() : "");
        String name = "";
        if (this instanceof IPkgDescExtra) {
            name = ((IPkgDescExtra)((Object)this)).getNameDisplay();
        } else if (this instanceof IPkgDescAddon) {
            name = ((IPkgDescAddon)((Object)this)).getName().getDisplay();
        }
        result = result.replace("$NAME", name);
        int start = result.indexOf("{|");
        while (start >= 0) {
            end = result.indexOf(125, start);
            int last = start + 1;
            int pipe = result.indexOf(124, last + 1);
            while (pipe > start) {
                if (pipe - last > 1) {
                    result = result.substring(0, start) + result.substring(last + 1, pipe) + result.substring(end + 1);
                    break;
                }
                last = pipe;
                pipe = result.indexOf(124, last + 1);
            }
            start = result.indexOf("{|");
        }
        start = result.indexOf("{?");
        while (start >= 0) {
            end = result.indexOf(125, start);
            int op = result.indexOf(">1:");
            if (op > start) {
                String value = "";
                try {
                    FullRevision i = FullRevision.parseRevision(result.substring(start + 2, op));
                    if (i.compareTo(new FullRevision(1)) > 0) {
                        value = result.substring(op + 3, end);
                    }
                }
                catch (NumberFormatException e) {
                    value = "ERROR " + e.getMessage() + " in " + result.substring(start, end + 1);
                }
                result = result.substring(0, start) + value + result.substring(end + 1);
            }
            start = result.indexOf("{?");
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<PkgDesc");
        builder.append(" Type=");
        builder.append(this.getType().toString().toLowerCase(Locale.US).replace("pkg_", ""));
        if (this.hasAndroidVersion()) {
            builder.append(" Android=").append(this.getAndroidVersion());
        }
        if (this.hasVendor()) {
            builder.append(" Vendor=").append(this.getVendor().toString());
        }
        if (this.hasTag()) {
            builder.append(" Tag=").append(this.getTag());
        }
        if (this.hasPath()) {
            builder.append(" Path=").append(this.getPath());
        }
        if (this.hasFullRevision()) {
            builder.append(" FullRev=").append(this.getFullRevision());
        }
        if (this.hasMajorRevision()) {
            builder.append(" MajorRev=").append(this.getMajorRevision());
        }
        if (this.hasMinToolsRev()) {
            builder.append(" MinToolsRev=").append(this.getMinToolsRev());
        }
        if (this.hasMinPlatformToolsRev()) {
            builder.append(" MinPlatToolsRev=").append(this.getMinPlatformToolsRev());
        }
        if (this.mListDisplay != null) {
            builder.append(" ListDisp=").append(this.mListDisplay);
        }
        if (this.mDescriptionShort != null) {
            builder.append(" DescShort=").append(this.mDescriptionShort);
        }
        if (this.mDescriptionUrl != null) {
            builder.append(" DescUrl=").append(this.mDescriptionUrl);
        }
        if (this.mLicense != null) {
            builder.append(" License['").append(this.mLicense.getLicenseRef()).append("]=").append(this.mLicense.getLicense().length()).append(" chars");
        }
        if (this.isObsolete()) {
            builder.append(" Obsolete=yes");
        }
        builder.append('>');
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hasAndroidVersion() ? this.getAndroidVersion().hashCode() : 0);
        result = 31 * result + (this.hasVendor() ? this.getVendor().hashCode() : 0);
        result = 31 * result + (this.hasTag() ? this.getTag().hashCode() : 0);
        result = 31 * result + (this.hasPath() ? this.getPath().hashCode() : 0);
        result = 31 * result + (this.hasFullRevision() ? this.getFullRevision().hashCode() : 0);
        result = 31 * result + (this.hasMajorRevision() ? this.getMajorRevision().hashCode() : 0);
        result = 31 * result + (this.hasMinToolsRev() ? this.getMinToolsRev().hashCode() : 0);
        result = 31 * result + (this.hasMinPlatformToolsRev() ? this.getMinPlatformToolsRev().hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IPkgDesc)) {
            return false;
        }
        IPkgDesc rhs = (IPkgDesc)obj;
        if (this.hasAndroidVersion() != rhs.hasAndroidVersion()) {
            return false;
        }
        if (this.hasAndroidVersion() && !this.getAndroidVersion().equals(rhs.getAndroidVersion())) {
            return false;
        }
        if (this.hasTag() != rhs.hasTag()) {
            return false;
        }
        if (this.hasTag() && !this.getTag().equals(rhs.getTag())) {
            return false;
        }
        if (this.hasPath() != rhs.hasPath()) {
            return false;
        }
        if (this.hasPath() && !this.getPath().equals(rhs.getPath())) {
            return false;
        }
        if (this.hasFullRevision() != rhs.hasFullRevision()) {
            return false;
        }
        if (this.hasFullRevision() && !this.getFullRevision().equals(rhs.getFullRevision())) {
            return false;
        }
        if (this.hasMajorRevision() != rhs.hasMajorRevision()) {
            return false;
        }
        if (this.hasMajorRevision() && !this.getMajorRevision().equals(rhs.getMajorRevision())) {
            return false;
        }
        if (this.hasMinToolsRev() != rhs.hasMinToolsRev()) {
            return false;
        }
        if (this.hasMinToolsRev() && !this.getMinToolsRev().equals(rhs.getMinToolsRev())) {
            return false;
        }
        if (this.hasMinPlatformToolsRev() != rhs.hasMinPlatformToolsRev()) {
            return false;
        }
        return !this.hasMinPlatformToolsRev() || this.getMinPlatformToolsRev().equals(rhs.getMinPlatformToolsRev());
    }

    private static String sanitize(String str) {
        str = str.toLowerCase(Locale.US).replaceAll("[^a-z0-9_.-]+", "_").replaceAll("_+", "_");
        return str;
    }

    public static class Builder {
        private final PkgType mType;
        private FullRevision mFullRevision;
        private MajorRevision mMajorRevision;
        private AndroidVersion mAndroidVersion;
        private String mPath;
        private IdDisplay mTag;
        private IdDisplay mVendor;
        private FullRevision mMinToolsRev;
        private FullRevision mMinPlatformToolsRev;
        private IIsUpdateFor mCustomIsUpdateFor;
        private IGetPath mCustomPath;
        private String[] mOldPaths;
        private String mNameDisplay;
        private IdDisplay mNameIdDisplay;
        private License mLicense;
        private String mListDisplay;
        private String mDescriptionShort;
        private String mDescriptionUrl;
        private boolean mIsObsolete;

        private Builder(PkgType type) {
            this.mType = type;
        }

        public static Builder newTool(FullRevision revision, FullRevision minPlatformToolsRev) {
            Builder p = new Builder(PkgType.PKG_TOOLS);
            p.mFullRevision = revision;
            p.mMinPlatformToolsRev = minPlatformToolsRev;
            return p;
        }

        public static Builder newPlatformTool(FullRevision revision) {
            Builder p = new Builder(PkgType.PKG_PLATFORM_TOOLS);
            p.mFullRevision = revision;
            return p;
        }

        public static Builder newBuildTool(FullRevision revision) {
            Builder p = new Builder(PkgType.PKG_BUILD_TOOLS);
            p.mFullRevision = revision;
            p.mCustomIsUpdateFor = new IIsUpdateFor(){

                @Override
                public boolean isUpdateFor(PkgDesc thisPkgDesc, IPkgDesc existingDesc) {
                    return thisPkgDesc.isGenericUpdateFor(existingDesc, FullRevision.PreviewComparison.COMPARE_NUMBER) && thisPkgDesc.getFullRevision().compareTo(existingDesc.getFullRevision(), FullRevision.PreviewComparison.COMPARE_TYPE) == 0;
                }
            };
            return p;
        }

        public static Builder newDoc(AndroidVersion version, MajorRevision revision) {
            Builder p = new Builder(PkgType.PKG_DOC);
            p.mAndroidVersion = version;
            p.mMajorRevision = revision;
            p.mCustomIsUpdateFor = new IIsUpdateFor(){

                @Override
                public boolean isUpdateFor(PkgDesc thisPkgDesc, IPkgDesc existingDesc) {
                    if (existingDesc == null || !thisPkgDesc.getType().equals(existingDesc.getType())) {
                        return false;
                    }
                    int diff = thisPkgDesc.getAndroidVersion().compareTo(existingDesc.getAndroidVersion());
                    return diff > 0 || diff == 0 && thisPkgDesc.getMajorRevision().compareTo(existingDesc.getMajorRevision()) > 0;
                }
            };
            return p;
        }

        public static Builder newExtra(IdDisplay vendor, String path, String displayName, String[] oldPaths, NoPreviewRevision revision) {
            Builder p = new Builder(PkgType.PKG_EXTRA);
            p.mFullRevision = revision;
            p.mVendor = vendor;
            p.mPath = path;
            p.mNameDisplay = displayName;
            p.mOldPaths = oldPaths;
            return p;
        }

        public static Builder newPlatform(AndroidVersion version, MajorRevision revision, FullRevision minToolsRev) {
            Builder p = new Builder(PkgType.PKG_PLATFORM);
            p.mAndroidVersion = version;
            p.mMajorRevision = revision;
            p.mMinToolsRev = minToolsRev;
            p.mCustomPath = new IGetPath(){

                @Override
                public String getPath(PkgDesc thisPkgDesc) {
                    return AndroidTargetHash.getPlatformHashString(thisPkgDesc.getAndroidVersion());
                }
            };
            return p;
        }

        public static Builder newAddon(AndroidVersion version, MajorRevision revision, IdDisplay addonVendor, IdDisplay addonName) {
            Builder p = new Builder(PkgType.PKG_ADDON);
            p.mAndroidVersion = version;
            p.mMajorRevision = revision;
            p.mVendor = addonVendor;
            p.mNameIdDisplay = addonName;
            return p;
        }

        public static Builder newSysImg(AndroidVersion version, IdDisplay tag, String abi, MajorRevision revision) {
            Builder p = new Builder(PkgType.PKG_SYS_IMAGE);
            p.mAndroidVersion = version;
            p.mMajorRevision = revision;
            p.mTag = tag;
            p.mPath = abi;
            p.mVendor = null;
            return p;
        }

        public static Builder newAddonSysImg(AndroidVersion version, IdDisplay addonVendor, IdDisplay addonName, String abi, MajorRevision revision) {
            Builder p = new Builder(PkgType.PKG_ADDON_SYS_IMAGE);
            p.mAndroidVersion = version;
            p.mMajorRevision = revision;
            p.mTag = addonName;
            p.mPath = abi;
            p.mVendor = addonVendor;
            return p;
        }

        public static Builder newSource(AndroidVersion version, MajorRevision revision) {
            Builder p = new Builder(PkgType.PKG_SOURCE);
            p.mAndroidVersion = version;
            p.mMajorRevision = revision;
            return p;
        }

        public static Builder newSample(AndroidVersion version, MajorRevision revision, FullRevision minToolsRev) {
            Builder p = new Builder(PkgType.PKG_SAMPLE);
            p.mAndroidVersion = version;
            p.mMajorRevision = revision;
            p.mMinToolsRev = minToolsRev;
            return p;
        }

        public static Builder newNdk(FullRevision revision) {
            Builder p = new Builder(PkgType.PKG_NDK);
            p.mFullRevision = revision;
            return p;
        }

        public static Builder newLLDB(FullRevision revision) {
            Builder p = new Builder(PkgType.PKG_LLDB);
            p.mFullRevision = revision;
            return p;
        }

        public Builder setLicense(License license) {
            this.mLicense = license;
            return this;
        }

        public Builder setListDisplay(String text) {
            this.mListDisplay = text;
            return this;
        }

        public Builder setDescriptionShort(String text) {
            this.mDescriptionShort = text;
            return this;
        }

        public Builder setDescriptionUrl(String text) {
            this.mDescriptionUrl = text;
            return this;
        }

        public Builder setIsObsolete(boolean isObsolete) {
            this.mIsObsolete = isObsolete;
            return this;
        }

        public IPkgDesc create() {
            if (this.mType == PkgType.PKG_ADDON) {
                return new PkgDescAddon(this.mType, this.mLicense, this.mListDisplay, this.mDescriptionShort, this.mDescriptionUrl, this.mIsObsolete, this.mMajorRevision, this.mAndroidVersion, this.mVendor, this.mNameIdDisplay);
            }
            if (this.mType == PkgType.PKG_EXTRA) {
                return new PkgDescExtra(this.mType, this.mLicense, this.mListDisplay, this.mDescriptionShort, this.mDescriptionUrl, this.mIsObsolete, this.mFullRevision, this.mMajorRevision, this.mAndroidVersion, this.mPath, this.mTag, this.mVendor, this.mMinToolsRev, this.mMinPlatformToolsRev, this.mNameDisplay, this.mOldPaths);
            }
            return new PkgDesc(this.mType, this.mLicense, this.mListDisplay, this.mDescriptionShort, this.mDescriptionUrl, this.mIsObsolete, this.mFullRevision, this.mMajorRevision, this.mAndroidVersion, this.mPath, this.mTag, this.mVendor, this.mMinToolsRev, this.mMinPlatformToolsRev, this.mCustomIsUpdateFor, this.mCustomPath);
        }
    }

    public static interface IGetPath {
        public String getPath(PkgDesc var1);
    }

    public static interface IIsUpdateFor {
        public boolean isUpdateFor(PkgDesc var1, IPkgDesc var2);
    }
}

