/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ApplicationNamesInfo {
    private String myProductName;
    private String myFullProductName;
    private String myLowercaseProductName;
    private String myScriptName;

    @NotNull
    public static ApplicationNamesInfo getInstance() {
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfoHolder.ourInstance;
        if (applicationNamesInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/ApplicationNamesInfo", "getInstance"));
        }
        return applicationNamesInfo;
    }

    private ApplicationNamesInfo() {
        try {
            this.readInfo(JDOMUtil.load(ApplicationNamesInfo.class.getResourceAsStream("/idea/" + ApplicationNamesInfo.getComponentName() + ".xml")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readInfo(Element rootElement) {
        Element names2 = rootElement.getChild("names");
        this.myProductName = names2.getAttributeValue("product");
        this.myFullProductName = names2.getAttributeValue("fullname");
        this.myLowercaseProductName = StringUtil.capitalize(this.myProductName.toLowerCase());
        this.myScriptName = names2.getAttributeValue("script");
    }

    public String getProductName() {
        return this.myProductName;
    }

    public static String getComponentName() {
        String prefix = System.getProperty("idea.platform.prefix");
        if (prefix != null) {
            return prefix + "ApplicationInfo";
        }
        return "ApplicationInfo";
    }

    private static class ApplicationNamesInfoHolder {
        private static final ApplicationNamesInfo ourInstance = new ApplicationNamesInfo();
    }
}

