/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VirtualFile
extends UserDataHolderBase
implements ModificationTracker {
    public static final Key<Object> REQUESTOR_MARKER = Key.create("REQUESTOR_MARKER");
    public static final VirtualFile[] EMPTY_ARRAY = new VirtualFile[0];
    @NonNls
    public static final String PROP_HIDDEN = VFileProperty.HIDDEN.getName();
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.vfs.VirtualFile");
    private static final Key<byte[]> BOM_KEY = Key.create("BOM");
    private static final Key<Charset> CHARSET_KEY = Key.create("CHARSET");
    private static final Key<String> DETECTED_LINE_SEPARATOR_KEY = Key.create("DETECTED_LINE_SEPARATOR_KEY");

    protected VirtualFile() {
    }

    @NotNull
    @NonNls
    public abstract String getName();

    @NotNull
    public abstract VirtualFileSystem getFileSystem();

    @NotNull
    public abstract String getPath();

    @NotNull
    public String getUrl() {
        String string = VirtualFileManager.constructUrl(this.getFileSystem().getProtocol(), this.getPath());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VirtualFile", "getUrl"));
        }
        return string;
    }

    @NotNull
    public final String getPresentableUrl() {
        String string = this.getFileSystem().extractPresentableUrl(this.getPath());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VirtualFile", "getPresentableUrl"));
        }
        return string;
    }

    @Nullable
    @NonNls
    public String getExtension() {
        String name = this.getName();
        int index2 = name.lastIndexOf(46);
        if (index2 < 0) {
            return null;
        }
        return name.substring(index2 + 1);
    }

    @NonNls
    @NotNull
    public String getNameWithoutExtension() {
        String name = this.getName();
        int index2 = name.lastIndexOf(46);
        if (index2 < 0) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VirtualFile", "getNameWithoutExtension"));
            }
            return string;
        }
        String string = name.substring(0, index2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VirtualFile", "getNameWithoutExtension"));
        }
        return string;
    }

    public void rename(Object requestor, @NotNull @NonNls String newName) throws IOException {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/vfs/VirtualFile", "rename"));
        }
        if (this.getName().equals(newName)) {
            return;
        }
        if (!VirtualFile.isValidName(newName)) {
            throw new IOException(VfsBundle.message("file.invalid.name.error", newName));
        }
        this.getFileSystem().renameFile(requestor, this, newName);
    }

    public abstract boolean isWritable();

    public void setWritable(boolean writable) throws IOException {
        throw new IOException("Not supported");
    }

    public abstract boolean isDirectory();

    public boolean is(@NotNull VFileProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/openapi/vfs/VirtualFile", "is"));
        }
        return false;
    }

    @Nullable
    public String getCanonicalPath() {
        return this.getPath();
    }

    @Nullable
    public VirtualFile getCanonicalFile() {
        return this;
    }

    public abstract boolean isValid();

    public abstract VirtualFile getParent();

    public abstract VirtualFile[] getChildren();

    @Nullable
    public VirtualFile findChild(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/VirtualFile", "findChild"));
        }
        VirtualFile[] children = this.getChildren();
        if (children == null) {
            return null;
        }
        for (VirtualFile child : children) {
            if (!child.nameEquals(name)) continue;
            return child;
        }
        return null;
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFile(this);
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VirtualFile", "getFileType"));
        }
        return fileType;
    }

    @Nullable
    public VirtualFile findFileByRelativePath(@NotNull @NonNls String relPath) {
        VirtualFile canonicalFile;
        String name;
        if (relPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relPath", "com/intellij/openapi/vfs/VirtualFile", "findFileByRelativePath"));
        }
        if (relPath.isEmpty()) {
            return this;
        }
        int index2 = (relPath = StringUtil.trimStart(relPath, "/")).indexOf(47);
        if (index2 < 0) {
            index2 = relPath.length();
        }
        VirtualFile child = (name = relPath.substring(0, index2)).equals(".") ? this : (name.equals("..") ? (this.is(VFileProperty.SYMLINK) ? ((canonicalFile = this.getCanonicalFile()) != null ? canonicalFile.getParent() : null) : this.getParent()) : this.findChild(name));
        if (child == null) {
            return null;
        }
        if (index2 < relPath.length()) {
            return child.findFileByRelativePath(relPath.substring(index2 + 1));
        }
        return child;
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull @NonNls String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/VirtualFile", "createChildDirectory"));
        }
        if (!this.isDirectory()) {
            throw new IOException(VfsBundle.message("directory.create.wrong.parent.error", new Object[0]));
        }
        if (!this.isValid()) {
            throw new IOException(VfsBundle.message("invalid.directory.create.files", new Object[0]));
        }
        if (!VirtualFile.isValidName(name)) {
            throw new IOException(VfsBundle.message("directory.invalid.name.error", name));
        }
        if (this.findChild(name) != null) {
            throw new IOException(VfsBundle.message("file.create.already.exists.error", this.getUrl(), name));
        }
        VirtualFile virtualFile = this.getFileSystem().createChildDirectory(requestor, this, name);
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VirtualFile", "createChildDirectory"));
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile createChildData(Object requestor, @NotNull @NonNls String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/VirtualFile", "createChildData"));
        }
        if (!this.isDirectory()) {
            throw new IOException(VfsBundle.message("file.create.wrong.parent.error", new Object[0]));
        }
        if (!this.isValid()) {
            throw new IOException(VfsBundle.message("invalid.directory.create.files", new Object[0]));
        }
        if (!VirtualFile.isValidName(name)) {
            throw new IOException(VfsBundle.message("file.invalid.name.error", name));
        }
        if (this.findChild(name) != null) {
            throw new IOException(VfsBundle.message("file.create.already.exists.error", this.getUrl(), name));
        }
        VirtualFile virtualFile = this.getFileSystem().createChildFile(requestor, this, name);
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VirtualFile", "createChildData"));
        }
        return virtualFile;
    }

    public void delete(Object requestor) throws IOException {
        LOG.assertTrue(this.isValid(), "Deleting invalid file");
        this.getFileSystem().deleteFile(requestor, this);
    }

    public VirtualFile copy(final Object requestor, final @NotNull VirtualFile newParent, final @NotNull String copyName) throws IOException {
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/openapi/vfs/VirtualFile", "copy"));
        }
        if (copyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyName", "com/intellij/openapi/vfs/VirtualFile", "copy"));
        }
        if (this.getFileSystem() != newParent.getFileSystem()) {
            throw new IOException(VfsBundle.message("file.copy.error", newParent.getPresentableUrl()));
        }
        if (!newParent.isDirectory()) {
            throw new IOException(VfsBundle.message("file.copy.target.must.be.directory", new Object[0]));
        }
        return EncodingRegistry.doActionAndRestoreEncoding(this, new ThrowableComputable<VirtualFile, IOException>(){

            @Override
            public VirtualFile compute() throws IOException {
                return VirtualFile.this.getFileSystem().copyFile(requestor, VirtualFile.this, newParent, copyName);
            }
        });
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.getStoredCharset();
        if (charset == null) {
            charset = EncodingRegistry.getInstance().getDefaultCharset();
            this.setCharset(charset);
        }
        Charset charset2 = charset;
        if (charset2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VirtualFile", "getCharset"));
        }
        return charset2;
    }

    @Nullable
    protected Charset getStoredCharset() {
        return this.getUserData(CHARSET_KEY);
    }

    protected void storeCharset(Charset charset) {
        this.putUserData(CHARSET_KEY, charset);
    }

    public void setCharset(Charset charset) {
        this.setCharset(charset, null);
    }

    public void setCharset(Charset charset, @Nullable Runnable whenChanged) {
        Charset old = this.getStoredCharset();
        this.storeCharset(charset);
        if (Comparing.equal(charset, old)) {
            return;
        }
        byte[] bom = charset == null ? null : CharsetToolkit.getMandatoryBom(charset);
        byte[] existingBOM = this.getBOM();
        if (bom == null && charset != null && existingBOM != null) {
            bom = (byte[])(CharsetToolkit.canHaveBom(charset, existingBOM) ? existingBOM : null);
        }
        this.setBOM(bom);
        if (old != null) {
            if (whenChanged != null) {
                whenChanged.run();
            }
            VirtualFileManager.getInstance().notifyPropertyChanged(this, "encoding", old, charset);
        }
    }

    public boolean isCharsetSet() {
        return this.getStoredCharset() != null;
    }

    public final void setBinaryContent(@NotNull byte[] content) throws IOException {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/vfs/VirtualFile", "setBinaryContent"));
        }
        this.setBinaryContent(content, -1L, -1L);
    }

    /*
     * WARNING - void declaration
     */
    public void setBinaryContent(@NotNull byte[] content, long newModificationStamp, long l) throws IOException {
        void newTimeStamp;
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/vfs/VirtualFile", "setBinaryContent"));
        }
        this.setBinaryContent(content, newModificationStamp, (long)newTimeStamp, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setBinaryContent(@NotNull byte[] content, long newModificationStamp, long newTimeStamp, Object object) throws IOException {
        void requestor;
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/vfs/VirtualFile", "setBinaryContent"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        OutputStream outputStream = this.getOutputStream(requestor, newModificationStamp, newTimeStamp);
        try {
            outputStream.write(content);
            outputStream.flush();
        }
        finally {
            outputStream.close();
        }
    }

    @NotNull
    public abstract OutputStream getOutputStream(Object var1, long var2, long var4) throws IOException;

    @NotNull
    public abstract byte[] contentsToByteArray() throws IOException;

    @NotNull
    public byte[] contentsToByteArray(boolean cacheContent) throws IOException {
        byte[] byArray = this.contentsToByteArray();
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VirtualFile", "contentsToByteArray"));
        }
        return byArray;
    }

    public long getModificationStamp() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public abstract long getTimeStamp();

    public abstract long getLength();

    @Override
    public long getModificationCount() {
        return this.isValid() ? this.getTimeStamp() : -1L;
    }

    protected boolean nameEquals(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/VirtualFile", "nameEquals"));
        }
        return this.getName().equals(name);
    }

    @Nullable
    public byte[] getBOM() {
        return this.getUserData(BOM_KEY);
    }

    public void setBOM(@Nullable byte[] BOM) {
        this.putUserData(BOM_KEY, BOM);
    }

    @NonNls
    public String toString() {
        return "VirtualFile: " + this.getPresentableUrl();
    }

    public boolean isInLocalFileSystem() {
        return false;
    }

    public static boolean isValidName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/VirtualFile", "isValidName"));
        }
        return name.length() > 0 && name.indexOf(92) < 0 && name.indexOf(47) < 0;
    }

    public void setDetectedLineSeparator(@Nullable String separator) {
        this.putUserData(DETECTED_LINE_SEPARATOR_KEY, separator);
    }

    public void setPreloadedContentHint(byte[] preloadedContentHint) {
    }
}

