/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import git4idea.history.GitChangeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLogStatusInfo {
    private final GitChangeType myType;
    private final String myPath;
    private final String mySecondPath;

    GitLogStatusInfo(@NotNull GitChangeType type, @NotNull String path, @Nullable String secondPath) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "git4idea/history/GitLogStatusInfo", "<init>"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitLogStatusInfo", "<init>"));
        }
        this.mySecondPath = secondPath;
        this.myPath = path;
        this.myType = type;
    }

    @NotNull
    public String getFirstPath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogStatusInfo", "getFirstPath"));
        }
        return string;
    }

    @NotNull
    public GitChangeType getType() {
        GitChangeType gitChangeType = this.myType;
        if (gitChangeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogStatusInfo", "getType"));
        }
        return gitChangeType;
    }

    @Nullable
    public String getSecondPath() {
        return this.mySecondPath;
    }

    public String toString() {
        String s = this.myType.toString() + " " + this.myPath;
        if (this.mySecondPath != null) {
            s = s + " -> " + this.mySecondPath;
        }
        return s;
    }
}

