/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public final class GitFetchResult {
    private final Type myType;
    private Collection<Exception> myErrors;
    private Collection<String> myPrunedRefs;

    public GitFetchResult(@NotNull Type type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "git4idea/update/GitFetchResult", "<init>"));
        }
        this.myErrors = new ArrayList<Exception>();
        this.myPrunedRefs = new ArrayList<String>();
        this.myType = type;
    }

    @NotNull
    public static GitFetchResult success() {
        GitFetchResult gitFetchResult = new GitFetchResult(Type.SUCCESS);
        if (gitFetchResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetchResult", "success"));
        }
        return gitFetchResult;
    }

    @NotNull
    public static GitFetchResult cancel() {
        GitFetchResult gitFetchResult = new GitFetchResult(Type.CANCELLED);
        if (gitFetchResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetchResult", "cancel"));
        }
        return gitFetchResult;
    }

    @NotNull
    public static GitFetchResult error(Collection<Exception> errors) {
        GitFetchResult result = new GitFetchResult(Type.ERROR);
        result.myErrors = errors;
        GitFetchResult gitFetchResult = result;
        if (gitFetchResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetchResult", "error"));
        }
        return gitFetchResult;
    }

    @NotNull
    public static GitFetchResult error(Exception error) {
        GitFetchResult gitFetchResult = GitFetchResult.error(Collections.singletonList(error));
        if (gitFetchResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetchResult", "error"));
        }
        return gitFetchResult;
    }

    @NotNull
    public static GitFetchResult error(@NotNull String errorMessage) {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "git4idea/update/GitFetchResult", "error"));
        }
        GitFetchResult gitFetchResult = GitFetchResult.error(new Exception(errorMessage));
        if (gitFetchResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetchResult", "error"));
        }
        return gitFetchResult;
    }

    public boolean isSuccess() {
        return this.myType == Type.SUCCESS;
    }

    public boolean isCancelled() {
        return this.myType == Type.CANCELLED;
    }

    public boolean isNotAuthorized() {
        return this.myType == Type.NOT_AUTHORIZED;
    }

    public boolean isError() {
        return this.myType == Type.ERROR;
    }

    @NotNull
    public Collection<? extends Exception> getErrors() {
        Collection<Exception> collection = this.myErrors;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetchResult", "getErrors"));
        }
        return collection;
    }

    public void addPruneInfo(@NotNull Collection<String> prunedRefs) {
        if (prunedRefs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prunedRefs", "git4idea/update/GitFetchResult", "addPruneInfo"));
        }
        this.myPrunedRefs.addAll(prunedRefs);
    }

    @NotNull
    public Collection<String> getPrunedRefs() {
        Collection<String> collection = this.myPrunedRefs;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetchResult", "getPrunedRefs"));
        }
        return collection;
    }

    @NotNull
    public String getAdditionalInfo() {
        if (!this.myPrunedRefs.isEmpty()) {
            String string = "Pruned obsolete remote " + StringUtil.pluralize((String)"reference", (int)this.myPrunedRefs.size()) + ": " + StringUtil.join(this.myPrunedRefs, (String)", ");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetchResult", "getAdditionalInfo"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitFetchResult", "getAdditionalInfo"));
        }
        return "";
    }

    public static enum Type {
        SUCCESS,
        CANCELLED,
        NOT_AUTHORIZED,
        ERROR;

    }
}

