/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.context;

import com.intellij.codeInsight.daemon.impl.analysis.CreateNSDeclarationIntentionFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.intellij.lang.xpath.context.NamespaceContext;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.impl.XsltChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XsltNamespaceContext
implements NamespaceContext {
    public static final XsltNamespaceContext NAMESPACE_CONTEXT = new XsltNamespaceContext();

    @Override
    public String getNamespaceURI(String prefix, XmlElement context) {
        return XsltNamespaceContext.getNamespaceUriStatic(prefix, context);
    }

    @Nullable
    public static String getNamespaceUriStatic(String prefix, XmlElement context) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class);
        return tag != null ? tag.getNamespaceByPrefix(prefix) : null;
    }

    @Override
    @Nullable
    public String getPrefixForURI(String uri, XmlElement context) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class);
        return tag != null ? tag.getPrefixByNamespace(uri) : null;
    }

    @Override
    @NotNull
    public Collection<String> getKnownPrefixes(XmlElement context) {
        Collection<String> collection = XsltNamespaceContext.getPrefixes(context);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/context/XsltNamespaceContext", "getKnownPrefixes"));
        }
        return collection;
    }

    public static Collection<String> getPrefixes(XmlElement context) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class);
        if (tag != null) {
            String[] uris;
            HashSet<String> allPrefixes = new HashSet<String>();
            for (String uri : uris = tag.knownNamespaces()) {
                for (XmlTag p = tag; p != null; p = p.getParentTag()) {
                    Set localPrefixes = p.getLocalNamespaceDeclarations().entrySet();
                    for (Map.Entry entry : localPrefixes) {
                        String prefix = (String)entry.getKey();
                        if (prefix.isEmpty() || !((String)entry.getValue()).equals(uri) || allPrefixes.contains(prefix)) continue;
                        allPrefixes.add(prefix);
                    }
                }
            }
            return allPrefixes;
        }
        return Collections.emptySet();
    }

    @Override
    @Nullable
    public PsiElement resolve(String prefix, XmlElement context) {
        return XsltNamespaceContext.resolvePrefix(prefix, context);
    }

    @Nullable
    public static PsiElement resolvePrefix(final String prefix, XmlElement context) {
        String name = "xmlns:" + prefix;
        XmlTag parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class);
        while (parent != null) {
            final XmlAttribute attribute = parent.getAttribute(name, null);
            if (attribute != null) {
                TextRange textRange = TextRange.from((int)"xmlns:".length(), (int)prefix.length());
                return new SchemaPrefix(attribute, textRange, prefix){

                    public boolean equals(Object obj) {
                        if (obj instanceof SchemaPrefix) {
                            SchemaPrefix p = (SchemaPrefix)obj;
                            return prefix.equals(p.getName()) && p.getParent() == attribute;
                        }
                        return super.equals(obj);
                    }
                };
            }
            parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)parent, XmlTag.class);
        }
        return null;
    }

    @Override
    public IntentionAction[] getUnresolvedNamespaceFixes(PsiReference reference, String localName) {
        return XsltNamespaceContext.getUnresolvedNamespaceFixesStatic(reference, localName);
    }

    @Override
    public String getDefaultNamespace(XmlElement context) {
        if (context != null && XsltSupport.getXsltLanguageLevel(context.getContainingFile()) == XsltChecker.LanguageLevel.V2 && (context = (XmlElement)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class, (boolean)false)) != null) {
            do {
                XmlTag tag;
                String uri;
                if ((uri = (tag = (XmlTag)context).getAttributeValue("xpath-default-namespace", null)) == null && (uri = tag.getAttributeValue("xpath-default-namespace", "http://www.w3.org/1999/XSL/Transform")) == null) continue;
                return !uri.isEmpty() ? uri : null;
            } while ((context = (XmlElement)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class, (boolean)true)) != null);
        }
        return null;
    }

    public static IntentionAction[] getUnresolvedNamespaceFixesStatic(PsiReference reference, String localName) {
        XmlElementFactory factory = XmlElementFactory.getInstance((Project)reference.getElement().getProject());
        XmlTag tag = factory.createTagFromText((CharSequence)("<" + reference.getCanonicalText() + ":" + localName + " />"), (Language)XMLLanguage.INSTANCE);
        XmlFile xmlFile = (XmlFile)PsiTreeUtil.getContextOfType((PsiElement)reference.getElement(), XmlFile.class, (boolean)true);
        return new IntentionAction[]{new MyCreateNSDeclarationAction((XmlElement)tag, reference.getCanonicalText(), xmlFile)};
    }

    static class MyCreateNSDeclarationAction
    extends CreateNSDeclarationIntentionFix {
        private final XmlFile myXmlFile;

        public MyCreateNSDeclarationAction(XmlElement xmlElement, String prefix, XmlFile xmlFile) {
            super((PsiElement)xmlElement, prefix);
            this.myXmlFile = xmlFile;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/xpath/xslt/context/XsltNamespaceContext$MyCreateNSDeclarationAction", "invoke"));
            }
            super.invoke(project, editor, (PsiFile)this.myXmlFile);
        }

        public boolean showHint(@NotNull Editor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/intellij/lang/xpath/xslt/context/XsltNamespaceContext$MyCreateNSDeclarationAction", "showHint"));
            }
            return false;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/xpath/xslt/context/XsltNamespaceContext$MyCreateNSDeclarationAction", "isAvailable"));
            }
            return super.isAvailable(project, editor, (PsiFile)this.myXmlFile);
        }
    }
}

