/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.psi.impl;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.intellij.lang.xpath.psi.XPathFunction;
import org.intellij.lang.xpath.psi.XPathVariable;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.psi.XsltParameter;
import org.intellij.lang.xpath.xslt.psi.XsltTemplate;
import org.intellij.lang.xpath.xslt.psi.XsltVariable;
import org.intellij.lang.xpath.xslt.psi.impl.ImplicitModeElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XsltLanguage
extends Language {
    public static final String ID = "$XSLT";
    public static final XsltLanguage INSTANCE = new XsltLanguage();

    XsltLanguage() {
        super(ID);
        LanguageFindUsages.INSTANCE.addExplicitExtension((Object)this, (Object)new MyFindUsagesProvider());
        LanguageRefactoringSupport.INSTANCE.addExplicitExtension((Object)this, (Object)new RefactoringSupportProvider(){

            public boolean isInplaceRenameAvailable(@NotNull PsiElement element, PsiElement context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/xpath/xslt/psi/impl/XsltLanguage$1", "isInplaceRenameAvailable"));
                }
                return element instanceof XsltVariable && element.getUseScope() instanceof LocalSearchScope;
            }

            public boolean isSafeDeleteAvailable(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/xpath/xslt/psi/impl/XsltLanguage$1", "isSafeDeleteAvailable"));
                }
                return element instanceof XPathVariable || element instanceof XsltTemplate;
            }
        });
    }

    private static class MyFindUsagesProvider
    implements FindUsagesProvider {
        private MyFindUsagesProvider() {
        }

        @Nullable
        public WordsScanner getWordsScanner() {
            return ((FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage((Language)XMLLanguage.INSTANCE)).getWordsScanner();
        }

        public boolean canFindUsagesFor(@NotNull PsiElement psiElement) {
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/intellij/lang/xpath/xslt/psi/impl/XsltLanguage$MyFindUsagesProvider", "canFindUsagesFor"));
            }
            return psiElement instanceof PsiNamedElement;
        }

        @Nullable
        public String getHelpId(@NotNull PsiElement psiElement) {
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/intellij/lang/xpath/xslt/psi/impl/XsltLanguage$MyFindUsagesProvider", "getHelpId"));
            }
            return null;
        }

        @NotNull
        public String getType(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/xpath/xslt/psi/impl/XsltLanguage$MyFindUsagesProvider", "getType"));
            }
            if (element instanceof XsltParameter) {
                String string = MyFindUsagesProvider.getParameterType((XsltParameter)element);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltLanguage$MyFindUsagesProvider", "getType"));
                }
                return string;
            }
            if (element instanceof XPathVariable) {
                if ("variable" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltLanguage$MyFindUsagesProvider", "getType"));
                }
                return "variable";
            }
            if (element instanceof XsltTemplate) {
                if ("template" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltLanguage$MyFindUsagesProvider", "getType"));
                }
                return "template";
            }
            if (element instanceof XPathFunction) {
                if ("function" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltLanguage$MyFindUsagesProvider", "getType"));
                }
                return "function";
            }
            if (element instanceof ImplicitModeElement) {
                if ("mode" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltLanguage$MyFindUsagesProvider", "getType"));
                }
                return "mode";
            }
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltLanguage$MyFindUsagesProvider", "getType"));
            }
            return "";
        }

        private static String getParameterType(XsltParameter myTarget) {
            XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)myTarget.getNavigationElement(), XmlTag.class);
            if (parentTag != null) {
                if (XsltSupport.isXsltRootTag(parentTag)) {
                    return "stylesheet parameter";
                }
                if (XsltSupport.isTemplate(parentTag, false)) {
                    return "template parameter";
                }
            }
            return "parameter";
        }

        @NotNull
        public String getDescriptiveName(@NotNull PsiElement element) {
            String name;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/xpath/xslt/psi/impl/XsltLanguage$MyFindUsagesProvider", "getDescriptiveName"));
            }
            if (element instanceof PsiNamedElement && (name = ((PsiNamedElement)element).getName()) != null) {
                String string = name;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltLanguage$MyFindUsagesProvider", "getDescriptiveName"));
                }
                return string;
            }
            String string = element.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltLanguage$MyFindUsagesProvider", "getDescriptiveName"));
            }
            return string;
        }

        @NotNull
        public String getNodeText(@NotNull PsiElement element, boolean useFullName) {
            String name;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/xpath/xslt/psi/impl/XsltLanguage$MyFindUsagesProvider", "getNodeText"));
            }
            if (useFullName && element instanceof NavigationItem) {
                NavigationItem navigationItem = (NavigationItem)element;
                ItemPresentation presentation = navigationItem.getPresentation();
                if (presentation != null && presentation.getPresentableText() != null) {
                    String string = presentation.getPresentableText();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltLanguage$MyFindUsagesProvider", "getNodeText"));
                    }
                    return string;
                }
                String name2 = navigationItem.getName();
                if (name2 != null) {
                    String string = name2;
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltLanguage$MyFindUsagesProvider", "getNodeText"));
                    }
                    return string;
                }
            }
            if (element instanceof PsiNamedElement && (name = ((PsiNamedElement)element).getName()) != null) {
                String string = name;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltLanguage$MyFindUsagesProvider", "getNodeText"));
                }
                return string;
            }
            String string = element.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltLanguage$MyFindUsagesProvider", "getNodeText"));
            }
            return string;
        }
    }
}

