/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.intellij.lang.xpath.xslt.psi.XsltTemplate;
import org.intellij.lang.xpath.xslt.quickfix.AddParamBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddParameterFix
extends AddParamBase {
    private final String myName;
    private final XsltTemplate myTemplate;

    public AddParameterFix(String name, XsltTemplate template) {
        this.myName = name;
        this.myTemplate = template;
    }

    @NotNull
    public String getText() {
        String string = "Add Parameter '" + this.myName + "' to Template '" + this.myTemplate.getName() + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/quickfix/AddParameterFix", "getText"));
        }
        return string;
    }

    @Override
    protected String getParamName() {
        return this.myName;
    }

    @Override
    @Nullable
    protected XmlTag findTemplateTag() {
        return (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myTemplate.getNavigationElement(), XmlTag.class, (boolean)false);
    }

    @Override
    public boolean isAvailableImpl(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/xpath/xslt/quickfix/AddParameterFix", "isAvailableImpl"));
        }
        return this.myTemplate.isValid();
    }
}

