/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl;

import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.incremental.TargetTypeRegistry;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class BuildTargetRegistryImpl
implements BuildTargetRegistry {
    private final List<BuildTarget<?>> myAllTargets;
    private Map<BuildTargetType<?>, List<? extends BuildTarget<?>>> myTargets = new THashMap();
    private Map<JpsModule, List<ModuleBasedTarget>> myModuleBasedTargets = new THashMap();

    public BuildTargetRegistryImpl(JpsModel model) {
        ArrayList targetsByType = new ArrayList();
        for (BuildTargetType<?> type : TargetTypeRegistry.getInstance().getTargetTypes()) {
            List<?> targets = type.computeAllTargets(model);
            this.myTargets.put(type, targets);
            targetsByType.add(targets);
            for (BuildTarget target : targets) {
                if (!(target instanceof ModuleBasedTarget)) continue;
                ModuleBasedTarget t = (ModuleBasedTarget)target;
                JpsModule module = t.getModule();
                List<ModuleBasedTarget> list = this.myModuleBasedTargets.get(module);
                if (list == null) {
                    list = new ArrayList<ModuleBasedTarget>();
                    this.myModuleBasedTargets.put(module, list);
                }
                list.add(t);
            }
        }
        this.myAllTargets = Collections.unmodifiableList(ContainerUtil.concat(targetsByType));
    }

    @Override
    @NotNull
    public Collection<ModuleBasedTarget<?>> getModuleBasedTargets(@NotNull JpsModule module, @NotNull BuildTargetRegistry.ModuleTargetSelector selector) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/builders/impl/BuildTargetRegistryImpl", "getModuleBasedTargets"));
        }
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "org/jetbrains/jps/builders/impl/BuildTargetRegistryImpl", "getModuleBasedTargets"));
        }
        List<ModuleBasedTarget> targets = this.myModuleBasedTargets.get(module);
        if (targets == null || targets.isEmpty()) {
            List<ModuleBasedTarget<?>> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/BuildTargetRegistryImpl", "getModuleBasedTargets"));
            }
            return list;
        }
        SmartList result = new SmartList();
        for (ModuleBasedTarget target : targets) {
            switch (selector) {
                case ALL: {
                    result.add(target);
                    break;
                }
                case PRODUCTION: {
                    if (target.isTests()) break;
                    result.add(target);
                    break;
                }
                case TEST: {
                    if (!target.isTests()) break;
                    result.add(target);
                }
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/BuildTargetRegistryImpl", "getModuleBasedTargets"));
        }
        return smartList;
    }

    @Override
    @NotNull
    public <T extends BuildTarget<?>> List<T> getAllTargets(@NotNull BuildTargetType<T> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jps/builders/impl/BuildTargetRegistryImpl", "getAllTargets"));
        }
        List<? extends BuildTarget<?>> list = this.myTargets.get(type);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/BuildTargetRegistryImpl", "getAllTargets"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<BuildTarget<?>> getAllTargets() {
        List<BuildTarget<?>> list = this.myAllTargets;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/BuildTargetRegistryImpl", "getAllTargets"));
        }
        return list;
    }
}

