/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.designer;

import com.android.tools.idea.designer.AndroidVariationPaletteItem;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.designer.palette.PaletteItem;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public enum FillPolicy {
    NONE,
    BOTH,
    WIDTH,
    HEIGHT,
    OPPOSITE,
    WIDTH_IN_VERTICAL,
    HEIGHT_IN_HORIZONTAL;

    static Map<String, FillPolicy> ourNameToPolicy;

    public boolean fillHorizontally(boolean inVerticalContext) {
        return this == BOTH || this == WIDTH || inVerticalContext && (this == OPPOSITE || this == WIDTH_IN_VERTICAL);
    }

    public boolean fillVertically(boolean inVerticalContext) {
        return this == BOTH || this == HEIGHT || !inVerticalContext && (this == OPPOSITE || this == HEIGHT_IN_HORIZONTAL);
    }

    public static FillPolicy get(String fill) {
        FillPolicy fillPolicy = null;
        if (!fill.isEmpty()) {
            fillPolicy = ourNameToPolicy.get(fill);
        }
        if (fillPolicy == null) {
            fillPolicy = NONE;
        }
        return fillPolicy;
    }

    @NotNull
    public static FillPolicy getFillPreference(@NotNull RadViewComponent component) {
        AndroidVariationPaletteItem item;
        FillPolicy preference;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/designer/FillPolicy", "getFillPreference"));
        }
        PaletteItem paletteItem = component.getInitialPaletteItem();
        if (paletteItem instanceof AndroidVariationPaletteItem && (preference = (item = (AndroidVariationPaletteItem)paletteItem).getFillPolicy()) != null) {
            FillPolicy fillPolicy = preference;
            if (fillPolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/designer/FillPolicy", "getFillPreference"));
            }
            return fillPolicy;
        }
        FillPolicy fillPolicy = component.getMetaModel().getFillPolicy();
        if (fillPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/designer/FillPolicy", "getFillPreference"));
        }
        return fillPolicy;
    }

    static {
        ourNameToPolicy = new HashMap<String, FillPolicy>();
        for (FillPolicy pref : FillPolicy.values()) {
            ourNameToPolicy.put(pref.toString().toLowerCase(Locale.US), pref);
        }
    }
}

