/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service.path;

import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.rpclib.binary.BinaryClass;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.binary.Namespace;
import com.android.tools.rpclib.schema.Entity;
import com.android.tools.rpclib.schema.Field;
import com.android.tools.rpclib.schema.Pointer;
import com.android.tools.rpclib.schema.Primitive;
import com.android.tools.rpclib.schema.Struct;
import com.android.tools.rpclib.schema.Type;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class MemoryRangePath
extends Path {
    private AtomPath myAfter;
    private long myPool;
    private long myAddress;
    private long mySize;
    private static final Entity ENTITY = new Entity("path", "MemoryRange", "", "");

    @Override
    public StringBuilder stringPath(StringBuilder builder) {
        return this.myAfter.stringPath(builder).append(".MemoryRange<").append(this.myPool).append(">").append("[").append(Long.toHexString(this.myAddress)).append(":").append(Long.toHexString(this.getEndAddress())).append("]");
    }

    @Override
    public Path getParent() {
        return this.myAfter;
    }

    public long getEndAddress() {
        return this.myAddress + this.mySize - 1L;
    }

    public AtomPath getAfter() {
        return this.myAfter;
    }

    public MemoryRangePath setAfter(AtomPath v) {
        this.myAfter = v;
        return this;
    }

    public long getPool() {
        return this.myPool;
    }

    public MemoryRangePath setPool(long v) {
        this.myPool = v;
        return this;
    }

    public long getAddress() {
        return this.myAddress;
    }

    public MemoryRangePath setAddress(long v) {
        this.myAddress = v;
        return this;
    }

    public long getSize() {
        return this.mySize;
    }

    public MemoryRangePath setSize(long v) {
        this.mySize = v;
        return this;
    }

    @NotNull
    public BinaryClass klass() {
        Klass klass = Klass.INSTANCE;
        if (klass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/service/path/MemoryRangePath", "klass"));
        }
        return klass;
    }

    public static void register() {
    }

    static {
        ENTITY.setFields(new Field[]{new Field("After", (Type)new Pointer((Type)new Struct(AtomPath.Klass.INSTANCE.entity()))), new Field("Pool", (Type)new Primitive("uint64", 8)), new Field("Address", (Type)new Primitive("uint64", 8)), new Field("Size", (Type)new Primitive("uint64", 8))});
        Namespace.register((BinaryClass)Klass.INSTANCE);
    }

    public static enum Klass implements BinaryClass
    {
        INSTANCE;


        @NotNull
        public Entity entity() {
            Entity entity = ENTITY;
            if (entity == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/service/path/MemoryRangePath$Klass", "entity"));
            }
            return entity;
        }

        @NotNull
        public BinaryObject create() {
            MemoryRangePath memoryRangePath = new MemoryRangePath();
            if (memoryRangePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/service/path/MemoryRangePath$Klass", "create"));
            }
            return memoryRangePath;
        }

        public void encode(@NotNull Encoder e, BinaryObject obj) throws IOException {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/editors/gfxtrace/service/path/MemoryRangePath$Klass", "encode"));
            }
            MemoryRangePath o = (MemoryRangePath)obj;
            e.object((BinaryObject)o.myAfter);
            e.uint64(o.myPool);
            e.uint64(o.myAddress);
            e.uint64(o.mySize);
        }

        public void decode(@NotNull Decoder d, BinaryObject obj) throws IOException {
            if (d == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/android/tools/idea/editors/gfxtrace/service/path/MemoryRangePath$Klass", "decode"));
            }
            MemoryRangePath o = (MemoryRangePath)obj;
            o.myAfter = (AtomPath)d.object();
            o.myPool = d.uint64();
            o.myAddress = d.uint64();
            o.mySize = d.uint64();
        }
    }
}

