/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation.macros;

import com.android.tools.idea.editors.navigation.NavigationEditorUtils;
import com.android.tools.idea.editors.navigation.macros.CodeTemplate;
import com.android.tools.idea.editors.navigation.macros.MultiMatch;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;

public class Macros
extends AbstractProjectComponent {
    private static final String CREATE_INTENT = "void macro(Context context, Class activityClass) { new android.content.Intent(context, activityClass); }";
    private static final String DEFINE_INNER_CLASS = "void macro(Class $Interface, Void $method, Class $Type, Object $arg, final Statement $f) {    new $Interface() {        public void $method($Type $arg) {            $f.$();        }    };}";
    private static final String INSTALL_CLICK_LISTENER = "void macro(android.view.View $view, Statement $f) {    $view.setOnClickListener(new android.view.View.OnClickListener() {        @Override        public void onClick(android.view.View view) {            $f.$();        }    });}";
    private static final String INSTALL_MENU_ITEM_CLICK_LISTENER = "void macro(android.view.MenuItem $menuItem, final Statement $f, final boolean $consume) {    $menuItem.setOnMenuItemClickListener(new android.view.MenuItem.OnMenuItemClickListener() {        @Override        public boolean onMenuItemClick(android.view.MenuItem menuItem) {            $f.$();            return $consume;        }    });}";
    private static final String INSTALL_ITEM_CLICK_LISTENER = "void macro(ListView $listView, final Statement $f) {    $listView.setOnItemClickListener(new android.widget.AdapterView.OnItemClickListener() {        @Override        public void onItemClick(android.widget.AdapterView<?> parent, android.view.View view, int position, long id) {            $f.$$();        }    });}";
    private static final String FIND_MENU_ITEM = "void macro(Menu $menu, int $id) {    $menu.findItem(R.id.$id);}";
    private static final String FIND_VIEW_BY_ID_1 = "void macro(int $id) { findViewById(R.id.$id);}";
    private static final String FIND_VIEW_BY_ID_2 = "void macro(Object $finder, int $id) { $finder.findViewById(R.id.$id);}";
    public static final String FIND_FRAGMENT_BY_TAG = "void macro(void $fragmentManager, int $tag) { $fragmentManager.findFragmentByTag($tag);}";
    private static final String LAUNCH_ACTIVITY_WITH_ARG = "<T extends Serializable> void macro(Context context, Class activityClass, String name, T value) {    context.startActivity(new android.content.Intent(context, activityClass).putExtra(name, value));}";
    private MultiMatch createIntent;
    private MultiMatch installClickAndCallMacro;
    private MultiMatch installItemClickAndCallMacro;
    private MultiMatch installMenuItemClickAndCallMacro;
    private MultiMatch defineInnerClassToLaunchActivityMacro;
    private MultiMatch findMenuItem;
    private MultiMatch findViewById1;
    private MultiMatch findViewById2;
    private MultiMatch findFragmentByTag;

    public static Macros getInstance(Project project) {
        return (Macros)((Object)project.getComponent(Macros.class));
    }

    public MultiMatch createMacro(String methodDefinition) {
        return new MultiMatch(CodeTemplate.fromMethod(this.getMethodFromText(methodDefinition)));
    }

    private PsiMethod getMethodFromText(String definition) {
        return NavigationEditorUtils.createMethodFromText(this.myProject, definition, null);
    }

    public Macros(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/navigation/macros/Macros", "<init>"));
        }
        super(project);
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                Macros.this.createIntent = Macros.this.createMacro(Macros.CREATE_INTENT);
                Macros.this.findMenuItem = Macros.this.createMacro(Macros.FIND_MENU_ITEM);
                Macros.this.findViewById1 = Macros.this.createMacro(Macros.FIND_VIEW_BY_ID_1);
                Macros.this.findViewById2 = Macros.this.createMacro(Macros.FIND_VIEW_BY_ID_2);
                Macros.this.findFragmentByTag = Macros.this.createMacro(Macros.FIND_FRAGMENT_BY_TAG);
                Macros.this.installClickAndCallMacro = Macros.this.createMacro(Macros.INSTALL_CLICK_LISTENER);
                Macros.this.installItemClickAndCallMacro = Macros.this.createMacro(Macros.INSTALL_ITEM_CLICK_LISTENER);
                Macros.this.installMenuItemClickAndCallMacro = Macros.this.createMacro(Macros.INSTALL_MENU_ITEM_CLICK_LISTENER);
                Macros.this.defineInnerClassToLaunchActivityMacro = Macros.this.createMacro(Macros.DEFINE_INNER_CLASS);
                Macros.this.getDefineInnerClassToLaunchActivityMacro().addSubMacro("$f", CodeTemplate.fromMethod(Macros.this.getMethodFromText(Macros.LAUNCH_ACTIVITY_WITH_ARG)));
            }
        });
    }

    public MultiMatch getCreateIntent() {
        return this.createIntent;
    }

    public MultiMatch getInstallClickAndCallMacro() {
        return this.installClickAndCallMacro;
    }

    public MultiMatch getInstallItemClickAndCallMacro() {
        return this.installItemClickAndCallMacro;
    }

    public MultiMatch getInstallMenuItemClickAndCallMacro() {
        return this.installMenuItemClickAndCallMacro;
    }

    public MultiMatch getDefineInnerClassToLaunchActivityMacro() {
        return this.defineInnerClassToLaunchActivityMacro;
    }

    public MultiMatch getFindMenuItem() {
        return this.findMenuItem;
    }

    public MultiMatch getFindViewById1() {
        return this.findViewById1;
    }

    public MultiMatch getFindViewById2() {
        return this.findViewById2;
    }

    public MultiMatch getFindFragmentByTag() {
        return this.findFragmentByTag;
    }
}

