/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.tools.idea.rendering.LayoutPullParser;
import com.android.tools.lint.detector.api.LintUtils;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class DomPullParser
extends LayoutPullParser {
    @NotNull
    private final List<Element> myNodeStack = new ArrayList<Element>();
    private final Element myRoot;
    private Map<Element, ?> myViewCookies;

    public DomPullParser(Element root) {
        this.myRoot = root;
    }

    public DomPullParser setViewCookies(Map<Element, ?> viewCookies) {
        this.myViewCookies = viewCookies;
        return this;
    }

    public Element getRoot() {
        return this.myRoot;
    }

    protected Element getCurrentElement() {
        if (this.myNodeStack.size() > 0) {
            return this.myNodeStack.get(this.myNodeStack.size() - 1);
        }
        return null;
    }

    private Attr getAttribute(int i) {
        if (this.myParsingState != 2) {
            throw new IndexOutOfBoundsException();
        }
        Element element = this.getCurrentElement();
        if (element != null) {
            return (Attr)element.getAttributes().item(i);
        }
        return null;
    }

    private void push(@NotNull Element node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/rendering/DomPullParser", "push"));
        }
        this.myNodeStack.add(node);
    }

    @NotNull
    private Element pop() {
        Element element = this.myNodeStack.remove(this.myNodeStack.size() - 1);
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/DomPullParser", "pop"));
        }
        return element;
    }

    public Object getViewCookie() {
        Element element = this.getCurrentElement();
        if (this.myViewCookies != null) {
            return this.myViewCookies.get(element);
        }
        return element;
    }

    public Object getViewKey() {
        return this.getViewCookie();
    }

    public ILayoutPullParser getParser(String layoutName) {
        return null;
    }

    public String getPositionDescription() {
        return "XML DOM element depth:" + this.myNodeStack.size();
    }

    public int getAttributeCount() {
        Element node = this.getCurrentElement();
        if (node != null) {
            return node.getAttributes().getLength();
        }
        return 0;
    }

    public String getAttributeName(int i) {
        Attr attribute = this.getAttribute(i);
        if (attribute != null) {
            String localName = attribute.getLocalName();
            if (localName == null) {
                return attribute.getName();
            }
            return localName;
        }
        return null;
    }

    public String getAttributeNamespace(int i) {
        Attr attribute = this.getAttribute(i);
        if (attribute != null) {
            return attribute.getNamespaceURI();
        }
        return "";
    }

    public String getAttributePrefix(int i) {
        Attr attribute = this.getAttribute(i);
        if (attribute != null) {
            return attribute.getPrefix();
        }
        return null;
    }

    public String getAttributeValue(int i) {
        Attr attribute = this.getAttribute(i);
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    public String getAttributeValue(String namespace, String localName) {
        Element element = this.getCurrentElement();
        if (element != null) {
            Attr attribute = element.getAttributeNodeNS(namespace, localName);
            if (attribute == null && namespace != null && !namespace.equals("http://schemas.android.com/apk/res/android")) {
                attribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", localName);
            }
            if (attribute != null) {
                return attribute.getValue();
            }
        }
        return null;
    }

    public int getDepth() {
        return this.myNodeStack.size();
    }

    public String getName() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            Element currentNode = this.getCurrentElement();
            assert (currentNode != null);
            return currentNode.getTagName();
        }
        return null;
    }

    public String getNamespace() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            Element currentNode = this.getCurrentElement();
            assert (currentNode != null);
            return currentNode.getNamespaceURI();
        }
        return null;
    }

    public String getPrefix() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            Element currentNode = this.getCurrentElement();
            assert (currentNode != null);
            return currentNode.getPrefix();
        }
        return null;
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        if (this.myParsingState == 2) {
            Element currentNode = this.getCurrentElement();
            assert (currentNode != null);
            return currentNode.getChildNodes().getLength() == 0;
        }
        throw new XmlPullParserException("Call to isEmptyElementTag while not in START_TAG", (XmlPullParser)this, null);
    }

    @Override
    protected void onNextFromStartDocument() {
        if (this.myRoot != null) {
            this.push(this.myRoot);
            this.myParsingState = 2;
        } else {
            this.myParsingState = 1;
        }
    }

    @Override
    protected void onNextFromStartTag() {
        Element node = this.getCurrentElement();
        assert (node != null);
        List children = LintUtils.getChildren((Node)node);
        if (children.size() > 0) {
            this.push((Element)children.get(0));
            this.myParsingState = 2;
        } else {
            this.myParsingState = this.myParsingState == 0 ? 1 : 3;
        }
    }

    @Override
    protected void onNextFromEndTag() {
        Node sibling;
        Element node = this.getCurrentElement();
        assert (node != null);
        for (sibling = node.getNextSibling(); sibling != null && !(sibling instanceof Element); sibling = sibling.getNextSibling()) {
        }
        if (sibling != null) {
            node = (Element)sibling;
            this.pop();
            this.push(node);
            this.myParsingState = 2;
        } else {
            this.pop();
            this.myParsingState = this.myNodeStack.isEmpty() ? 1 : 3;
        }
    }

    public static DocumentBuilder createNewDocumentBuilder() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        try {
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Logger.getInstance(DomPullParser.class).error((Throwable)e);
            return null;
        }
    }

    public static Document createEmptyPlainDocument() {
        return DomPullParser.createNewDocumentBuilder().newDocument();
    }
}

