/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.run.AndroidApplicationLauncher;
import com.android.tools.idea.run.AndroidRunningState;
import com.android.tools.idea.stats.UsageTracker;
import com.intellij.execution.process.ProcessOutputTypes;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDeepLinkLauncher
extends AndroidApplicationLauncher {
    private final String APP_INDEXING_LOG_COMMEND = "setprop log.tag.AppIndexApi VERBOSE";
    @NotNull
    private final String myDeepLink;
    @NotNull
    private final String myExtraFlags;

    public AndroidDeepLinkLauncher(@NotNull String deepLink, @NotNull String extraFlags) {
        if (deepLink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deepLink", "com/android/tools/idea/run/AndroidDeepLinkLauncher", "<init>"));
        }
        if (extraFlags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraFlags", "com/android/tools/idea/run/AndroidDeepLinkLauncher", "<init>"));
        }
        this.APP_INDEXING_LOG_COMMEND = "setprop log.tag.AppIndexApi VERBOSE";
        this.myDeepLink = deepLink;
        this.myExtraFlags = extraFlags;
    }

    @Override
    public AndroidApplicationLauncher.LaunchResult launch(@NotNull AndroidRunningState state, @NotNull IDevice device) throws IOException, AdbCommandRejectedException, TimeoutException {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/run/AndroidDeepLinkLauncher", "launch"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/AndroidDeepLinkLauncher", "launch"));
        }
        if (state.isStopped()) {
            return AndroidApplicationLauncher.LaunchResult.STOP;
        }
        state.getProcessHandler().notifyTextAvailable("Launching application: " + this.myDeepLink + ".\n", ProcessOutputTypes.STDOUT);
        UsageTracker.getInstance().trackEvent("appIndexing", "deepLinkLaunched", null, null);
        AndroidApplicationLauncher.LaunchResult result = this.executeCommand("setprop log.tag.AppIndexApi VERBOSE", state, device);
        if (result == AndroidApplicationLauncher.LaunchResult.STOP) {
            return AndroidApplicationLauncher.LaunchResult.STOP;
        }
        String launchDeepLinkCommand = AndroidDeepLinkLauncher.getLaunchDeepLinkCommand(this.myDeepLink, state.getPackageName(), this.getDebugFlags(state), this.myExtraFlags);
        return this.executeCommand(launchDeepLinkCommand, state, device);
    }

    @NotNull
    static String getLaunchDeepLinkCommand(@NotNull String deepLink, @Nullable String packageId, @NotNull String debugFlags, @NotNull String extraFlags) {
        if (deepLink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deepLink", "com/android/tools/idea/run/AndroidDeepLinkLauncher", "getLaunchDeepLinkCommand"));
        }
        if (debugFlags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugFlags", "com/android/tools/idea/run/AndroidDeepLinkLauncher", "getLaunchDeepLinkCommand"));
        }
        if (extraFlags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraFlags", "com/android/tools/idea/run/AndroidDeepLinkLauncher", "getLaunchDeepLinkCommand"));
        }
        String string = "am start " + debugFlags + " " + "-a android.intent.action.VIEW " + "-c android.intent.category.BROWSABLE " + "-d " + deepLink + (packageId == null ? "" : " " + packageId) + (extraFlags.isEmpty() ? "" : " " + extraFlags);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidDeepLinkLauncher", "getLaunchDeepLinkCommand"));
        }
        return string;
    }
}

