/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.DeviceChooser;
import com.android.tools.idea.run.DeviceChooserDialog;
import com.android.tools.idea.run.DeviceCount;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceSelectionUtils {
    @NotNull
    private static final Logger LOG = Logger.getInstance(DeviceSelectionUtils.class);
    @NonNls
    private static final String ANDROID_TARGET_DEVICES_PROPERTY = "AndroidTargetDevices";

    @Nullable
    public static Collection<IDevice> chooseRunningDevice(final @NotNull AndroidFacet facet, final @NotNull Predicate<IDevice> deviceFilter, final @NotNull DeviceCount deviceCount) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/DeviceSelectionUtils", "chooseRunningDevice"));
        }
        if (deviceFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceFilter", "com/android/tools/idea/run/DeviceSelectionUtils", "chooseRunningDevice"));
        }
        if (deviceCount == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceCount", "com/android/tools/idea/run/DeviceSelectionUtils", "chooseRunningDevice"));
        }
        List<IDevice> compatibleDevices = DeviceSelectionUtils.getAllCompatibleDevices(deviceFilter);
        if (compatibleDevices.size() == 0) {
            return ImmutableList.of();
        }
        if (compatibleDevices.size() == 1) {
            return compatibleDevices;
        }
        final AtomicReference devicesRef = new AtomicReference();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                devicesRef.set(DeviceSelectionUtils.chooseDevicesManually(facet, (Predicate<IDevice>)deviceFilter, deviceCount));
            }
        }, ModalityState.defaultModalityState());
        return ((IDevice[])devicesRef.get()).length > 0 ? ImmutableList.copyOf((Object[])((Object[])devicesRef.get())) : null;
    }

    @NotNull
    public static List<IDevice> getAllCompatibleDevices(Predicate<IDevice> deviceFilter) {
        ArrayList<IDevice> compatibleDevices = new ArrayList<IDevice>();
        AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
        if (bridge != null) {
            IDevice[] devices;
            for (IDevice device : devices = bridge.getDevices()) {
                if (!deviceFilter.apply((Object)device)) continue;
                compatibleDevices.add(device);
            }
        }
        ArrayList<IDevice> arrayList = compatibleDevices;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/DeviceSelectionUtils", "getAllCompatibleDevices"));
        }
        return arrayList;
    }

    @NotNull
    public static Collection<IDevice> getOnlineDevices(@Nullable Collection<IDevice> devices) {
        if (devices == null) {
            List<IDevice> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/DeviceSelectionUtils", "getOnlineDevices"));
            }
            return list;
        }
        ArrayList online = Lists.newArrayListWithExpectedSize((int)devices.size());
        for (IDevice device : devices) {
            if (!device.isOnline()) continue;
            online.add(device);
        }
        ArrayList arrayList = online;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/DeviceSelectionUtils", "getOnlineDevices"));
        }
        return arrayList;
    }

    @NotNull
    private static IDevice[] chooseDevicesManually(@NotNull AndroidFacet facet, @NotNull Predicate<IDevice> filter, @NotNull DeviceCount deviceCount) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/DeviceSelectionUtils", "chooseDevicesManually"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/android/tools/idea/run/DeviceSelectionUtils", "chooseDevicesManually"));
        }
        if (deviceCount == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceCount", "com/android/tools/idea/run/DeviceSelectionUtils", "chooseDevicesManually"));
        }
        Project project = facet.getModule().getProject();
        String value = PropertiesComponent.getInstance((Project)project).getValue(ANDROID_TARGET_DEVICES_PROPERTY);
        String[] selectedSerials = value != null ? DeviceSelectionUtils.deserialize(value) : null;
        AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
        if (platform == null) {
            LOG.error("Android platform not set for module: " + facet.getModule().getName());
            if (DeviceChooser.EMPTY_DEVICE_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/DeviceSelectionUtils", "chooseDevicesManually"));
            }
            return DeviceChooser.EMPTY_DEVICE_ARRAY;
        }
        DeviceChooserDialog chooser = new DeviceChooserDialog(facet, platform.getTarget(), deviceCount.isMultiple(), selectedSerials, filter);
        chooser.show();
        IDevice[] devices = chooser.getSelectedDevices();
        if (chooser.getExitCode() != 0 || devices.length == 0) {
            if (DeviceChooser.EMPTY_DEVICE_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/DeviceSelectionUtils", "chooseDevicesManually"));
            }
            return DeviceChooser.EMPTY_DEVICE_ARRAY;
        }
        PropertiesComponent.getInstance((Project)project).setValue(ANDROID_TARGET_DEVICES_PROPERTY, DeviceSelectionUtils.serialize(devices));
        if (devices == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/DeviceSelectionUtils", "chooseDevicesManually"));
        }
        return devices;
    }

    @NotNull
    public static String serialize(@NotNull IDevice[] devices) {
        if (devices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "devices", "com/android/tools/idea/run/DeviceSelectionUtils", "serialize"));
        }
        StringBuilder builder = new StringBuilder();
        int n = devices.length;
        for (int i = 0; i < n; ++i) {
            builder.append(devices[i].getSerialNumber());
            if (i >= n - 1) continue;
            builder.append(' ');
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/DeviceSelectionUtils", "serialize"));
        }
        return string;
    }

    @NotNull
    private static String[] deserialize(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/android/tools/idea/run/DeviceSelectionUtils", "deserialize"));
        }
        String[] stringArray = s.split(" ");
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/DeviceSelectionUtils", "deserialize"));
        }
        return stringArray;
    }
}

