/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties;

import com.android.tools.idea.ui.properties.InvalidationListener;
import com.android.tools.idea.ui.properties.Observable;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.SettableValue;
import com.android.tools.idea.ui.properties.exceptions.BindingCycleException;
import com.android.tools.idea.ui.properties.expressions.bool.BooleanExpressions;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class BindingsManager {
    private static final int MAX_CYCLE_COUNT = 10;
    public static final InvokeStrategy APPLICATION_INVOKE_LATER_STRATEGY = new InvokeStrategy(){

        @Override
        public void invoke(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/android/tools/idea/ui/properties/BindingsManager$1", "invoke"));
            }
            ApplicationManager.getApplication().invokeLater(runnable, ModalityState.any());
        }
    };
    public static final InvokeStrategy SWING_INVOKE_LATER_STRATEGY = new InvokeStrategy(){

        @Override
        public void invoke(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/android/tools/idea/ui/properties/BindingsManager$2", "invoke"));
            }
            SwingUtilities.invokeLater(runnable);
        }
    };
    public static final InvokeStrategy INVOKE_IMMEDIATELY_STRATEGY = new InvokeStrategy(){

        @Override
        public void invoke(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/android/tools/idea/ui/properties/BindingsManager$3", "invoke"));
            }
            runnable.run();
        }
    };
    private final List<OneWayBinding<?>> myOneWayBindings = Lists.newArrayList();
    private final List<TwoWayBinding<?>> myTwoWayBindings = Lists.newArrayList();
    private final Queue<DestUpdater> myUpdaters = Queues.newArrayDeque();
    private final Queue<DestUpdater> myDeferredUpdaters = Queues.newArrayDeque();
    private boolean myUpdateInProgress;
    private int myCycleCount;
    private final InvokeStrategy myInvokeStrategy;

    public BindingsManager() {
        this(ApplicationManager.getApplication() != null ? APPLICATION_INVOKE_LATER_STRATEGY : SWING_INVOKE_LATER_STRATEGY);
    }

    public BindingsManager(InvokeStrategy invokeStrategy) {
        this.myInvokeStrategy = invokeStrategy;
    }

    public <T> void bind(@NotNull SettableValue<T> dest, @NotNull ObservableValue<T> src) {
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "com/android/tools/idea/ui/properties/BindingsManager", "bind"));
        }
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/android/tools/idea/ui/properties/BindingsManager", "bind"));
        }
        this.bind(dest, src, BooleanExpressions.TRUE);
    }

    public <T> void bind(@NotNull SettableValue<T> dest, @NotNull ObservableValue<T> src, @NotNull ObservableValue<Boolean> enabled) {
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "com/android/tools/idea/ui/properties/BindingsManager", "bind"));
        }
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/android/tools/idea/ui/properties/BindingsManager", "bind"));
        }
        if (enabled == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enabled", "com/android/tools/idea/ui/properties/BindingsManager", "bind"));
        }
        this.release(dest);
        this.myOneWayBindings.add(new OneWayBinding<T>(dest, src, enabled));
    }

    public <T> void bindTwoWay(@NotNull SettableValue<T> first, @NotNull SettableValue<T> second) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/android/tools/idea/ui/properties/BindingsManager", "bindTwoWay"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/android/tools/idea/ui/properties/BindingsManager", "bindTwoWay"));
        }
        this.releaseTwoWay(first, second);
        this.myTwoWayBindings.add(new TwoWayBinding<T>(first, second));
    }

    public void release(@NotNull SettableValue<?> dest) {
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "com/android/tools/idea/ui/properties/BindingsManager", "release"));
        }
        Iterator<OneWayBinding<?>> i = this.myOneWayBindings.iterator();
        while (i.hasNext()) {
            OneWayBinding<?> binding = i.next();
            if (((OneWayBinding)binding).myDest != dest) continue;
            binding.dispose();
            i.remove();
            return;
        }
    }

    public <T> void releaseTwoWay(@NotNull SettableValue<T> first, @NotNull SettableValue<T> second) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/android/tools/idea/ui/properties/BindingsManager", "releaseTwoWay"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/android/tools/idea/ui/properties/BindingsManager", "releaseTwoWay"));
        }
        Iterator<TwoWayBinding<?>> i = this.myTwoWayBindings.iterator();
        while (i.hasNext()) {
            TwoWayBinding<?> binding = i.next();
            if (((TwoWayBinding)binding).myLhs != first || ((TwoWayBinding)binding).myRhs != second) continue;
            binding.dispose();
            i.remove();
            return;
        }
    }

    public void releaseAll() {
        for (OneWayBinding<?> oneWayBinding : this.myOneWayBindings) {
            oneWayBinding.dispose();
        }
        this.myOneWayBindings.clear();
        for (TwoWayBinding twoWayBinding : this.myTwoWayBindings) {
            twoWayBinding.dispose();
        }
        this.myTwoWayBindings.clear();
    }

    private void enqueueUpdater(@NotNull DestUpdater updater) {
        if (updater == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updater", "com/android/tools/idea/ui/properties/BindingsManager", "enqueueUpdater"));
        }
        if (this.myUpdateInProgress) {
            if (!this.myDeferredUpdaters.contains(updater)) {
                this.myDeferredUpdaters.add(updater);
            }
            return;
        }
        boolean shouldInvoke = this.myUpdaters.isEmpty();
        if (!this.myUpdaters.contains(updater)) {
            this.myUpdaters.add(updater);
        }
        if (shouldInvoke) {
            this.invokeUpdate();
        }
    }

    private void invokeUpdate() {
        this.myInvokeStrategy.invoke(new Runnable(){

            @Override
            public void run() {
                BindingsManager.this.myUpdateInProgress = true;
                for (DestUpdater updater : BindingsManager.this.myUpdaters) {
                    updater.update();
                }
                BindingsManager.this.myUpdaters.clear();
                BindingsManager.this.myUpdateInProgress = false;
                if (!BindingsManager.this.myDeferredUpdaters.isEmpty()) {
                    BindingsManager.this.myCycleCount++;
                    if (BindingsManager.this.myCycleCount > 10) {
                        throw new BindingCycleException();
                    }
                    BindingsManager.this.myUpdaters.addAll(BindingsManager.this.myDeferredUpdaters);
                    BindingsManager.this.myDeferredUpdaters.clear();
                    BindingsManager.this.invokeUpdate();
                } else {
                    BindingsManager.this.myCycleCount = 0;
                }
            }
        });
    }

    private static final class DestUpdater<T> {
        private final SettableValue<T> myDest;
        private final ObservableValue<T> mySrc;

        public DestUpdater(SettableValue<T> dest, ObservableValue<T> src) {
            this.myDest = dest;
            this.mySrc = src;
        }

        public void update() {
            this.myDest.set(this.mySrc.get());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DestUpdater that = (DestUpdater)o;
            return Objects.equal(this.myDest, that.myDest) && Objects.equal(this.mySrc, that.mySrc);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.myDest, this.mySrc});
        }
    }

    private class TwoWayBinding<T> {
        private final SettableValue<T> myLhs;
        private final SettableValue<T> myRhs;
        private final InvalidationListener myLeftChangedListener = new InvalidationListener(){

            @Override
            public void onInvalidated(@NotNull Observable sender) {
                if (sender == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/android/tools/idea/ui/properties/BindingsManager$TwoWayBinding$1", "onInvalidated"));
                }
                BindingsManager.this.enqueueUpdater(new DestUpdater(TwoWayBinding.this.myRhs, TwoWayBinding.this.myLhs));
            }
        };
        private final InvalidationListener myRightChangedListener = new InvalidationListener(){

            @Override
            public void onInvalidated(@NotNull Observable sender) {
                if (sender == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/android/tools/idea/ui/properties/BindingsManager$TwoWayBinding$2", "onInvalidated"));
                }
                BindingsManager.this.enqueueUpdater(new DestUpdater(TwoWayBinding.this.myLhs, TwoWayBinding.this.myRhs));
            }
        };

        public TwoWayBinding(SettableValue<T> lhs, SettableValue<T> rhs) {
            this.myLhs = lhs;
            this.myRhs = rhs;
            this.myLhs.addListener(this.myLeftChangedListener);
            this.myRhs.addListener(this.myRightChangedListener);
            this.myRightChangedListener.onInvalidated(rhs);
        }

        public void dispose() {
            this.myLhs.removeListener(this.myLeftChangedListener);
            this.myRhs.removeListener(this.myRightChangedListener);
        }
    }

    private class OneWayBinding<T>
    extends InvalidationListener {
        private final SettableValue<T> myDest;
        private final ObservableValue<T> mySrc;
        private final ObservableValue<Boolean> myEnabled;

        @Override
        protected void onInvalidated(@NotNull Observable sender) {
            if (sender == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/android/tools/idea/ui/properties/BindingsManager$OneWayBinding", "onInvalidated"));
            }
            if (this.myEnabled.get().booleanValue()) {
                BindingsManager.this.enqueueUpdater(new DestUpdater<T>(this.myDest, this.mySrc));
            }
        }

        public OneWayBinding(SettableValue<T> dest, ObservableValue<T> src, ObservableValue<Boolean> enabled) {
            this.myDest = dest;
            this.mySrc = src;
            this.myEnabled = enabled;
            this.mySrc.addListener(this);
            this.myEnabled.addListener(this);
            this.onInvalidated(src);
        }

        public void dispose() {
            this.mySrc.removeListener(this);
            this.myEnabled.removeListener(this);
        }
    }

    public static interface InvokeStrategy {
        public void invoke(@NotNull Runnable var1);
    }
}

