/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.table;

import com.android.tools.idea.designer.ResizeOperation;
import com.intellij.android.designer.designSurface.RootView;
import com.intellij.android.designer.designSurface.TreeDropToOperation;
import com.intellij.android.designer.designSurface.graphics.DrawingStyle;
import com.intellij.android.designer.designSurface.graphics.ResizeSelectionDecorator;
import com.intellij.android.designer.designSurface.layout.TableLayoutOperation;
import com.intellij.android.designer.designSurface.layout.caption.TableHorizontalCaptionOperation;
import com.intellij.android.designer.designSurface.layout.caption.TableVerticalCaptionOperation;
import com.intellij.android.designer.designSurface.layout.grid.GridDecorator;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.RadViewLayout;
import com.intellij.android.designer.model.RadViewLayoutWithData;
import com.intellij.android.designer.model.grid.GridInfo;
import com.intellij.android.designer.model.layout.table.RadCaptionTableColumn;
import com.intellij.android.designer.model.layout.table.RadCaptionTableRow;
import com.intellij.android.designer.model.layout.table.RadTableLayoutComponent;
import com.intellij.android.designer.model.layout.table.RadTableRowLayout;
import com.intellij.designer.componentTree.TreeEditOperation;
import com.intellij.designer.designSurface.ComponentDecorator;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.ICaption;
import com.intellij.designer.designSurface.ICaptionDecorator;
import com.intellij.designer.designSurface.ILayoutDecorator;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.StaticDecorator;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadLayout;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RadTableLayout
extends RadViewLayoutWithData
implements ILayoutDecorator,
ICaption,
ICaptionDecorator {
    private static final String[] LAYOUT_PARAMS = new String[]{"", "LinearLayout_Layout", "ViewGroup_MarginLayout"};
    private GridDecorator myGridDecorator;
    private ResizeSelectionDecorator mySelectionDecorator;
    private RadLayout myCaptionColumnLayout;
    private RadLayout myCaptionRowLayout;

    @Override
    @NotNull
    public String[] getLayoutParams() {
        if (LAYOUT_PARAMS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/table/RadTableLayout", "getLayoutParams"));
        }
        return LAYOUT_PARAMS;
    }

    public EditOperation processChildOperation(OperationContext context) {
        if (context.isCreate() || context.isPaste() || context.isAdd() || context.isMove()) {
            if (context.isTree()) {
                if (TreeEditOperation.isTarget((RadComponent)this.myContainer, (OperationContext)context)) {
                    return new TreeDropToOperation(this.myContainer, context);
                }
                return null;
            }
            return new TableLayoutOperation(this.myContainer, context);
        }
        if (context.is((Object)"resize_children")) {
            return new ResizeOperation(context);
        }
        return null;
    }

    private StaticDecorator getGridDecorator() {
        if (this.myGridDecorator == null) {
            this.myGridDecorator = new GridDecorator(this.myContainer);
        }
        return this.myGridDecorator;
    }

    @Override
    public void addStaticDecorators(List<StaticDecorator> decorators, List<RadComponent> selection) {
        if (selection.contains(this.myContainer)) {
            if (!(this.myContainer.getParent().getLayout() instanceof ILayoutDecorator)) {
                decorators.add(this.getGridDecorator());
            }
        } else {
            for (RadComponent component : selection) {
                RadComponent parent = component.getParent();
                if (parent != this.myContainer && (parent == null || parent.getParent() != this.myContainer)) continue;
                decorators.add(this.getGridDecorator());
                return;
            }
            super.addStaticDecorators(decorators, selection);
        }
    }

    @Override
    public ComponentDecorator getChildSelectionDecorator(RadComponent component, List<RadComponent> selection) {
        if (RadTableRowLayout.is(component)) {
            return super.getChildSelectionDecorator(component, selection);
        }
        if (this.mySelectionDecorator == null) {
            this.mySelectionDecorator = new ResizeSelectionDecorator(DrawingStyle.SELECTION);
            ResizeOperation.addResizePoints(this.mySelectionDecorator);
        }
        return this.mySelectionDecorator;
    }

    public ICaption getCaption(RadComponent component) {
        if (this.myContainer == component) {
            RadComponent parent = this.myContainer.getParent();
            if (parent.getLayout() instanceof ICaptionDecorator) {
                return null;
            }
            if ((parent = parent.getParent()) != null && parent.getLayout() instanceof ICaptionDecorator) {
                return null;
            }
        }
        if (this.myContainer.getChildren().isEmpty()) {
            return null;
        }
        return this;
    }

    @NotNull
    public List<RadComponent> getCaptionChildren(EditableArea mainArea, boolean horizontal) {
        boolean hasFrame;
        RadTableLayoutComponent container = (RadTableLayoutComponent)this.myContainer;
        List<RadComponent> children = container.getChildren();
        ArrayList<RadComponent> components = new ArrayList<RadComponent>();
        RootView nativeComponent = (RootView)((RadViewComponent)container.getRoot()).getNativeComponent();
        boolean bl = hasFrame = nativeComponent.getRenderedImage() != null && nativeComponent.getRenderedImage().getImageBounds() != null;
        if (horizontal) {
            GridInfo gridInfo = container.getGridInfo();
            int[] lines = gridInfo.vLines;
            boolean[] emptyColumns = gridInfo.emptyColumns;
            int offset = hasFrame ? (int)((double)nativeComponent.getShiftX() / nativeComponent.getScale()) : 0;
            for (int i = 0; i < lines.length - 1; ++i) {
                components.add((RadComponent)new RadCaptionTableColumn(mainArea, container, i, offset + lines[i], lines[i + 1] - lines[i], emptyColumns[i]));
            }
        } else {
            int offset = hasFrame ? (int)((double)nativeComponent.getShiftY() / nativeComponent.getScale()) : 0;
            for (RadComponent component : children) {
                components.add((RadComponent)new RadCaptionTableRow(mainArea, (RadViewComponent)component, offset));
            }
        }
        ArrayList<RadComponent> arrayList = components;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/table/RadTableLayout", "getCaptionChildren"));
        }
        return arrayList;
    }

    @NotNull
    public RadLayout getCaptionLayout(final EditableArea mainArea, boolean horizontal) {
        if (horizontal) {
            if (this.myCaptionColumnLayout == null) {
                this.myCaptionColumnLayout = new RadViewLayout(){

                    public EditOperation processChildOperation(OperationContext context) {
                        if (context.isMove()) {
                            return new TableHorizontalCaptionOperation((RadTableLayoutComponent)RadTableLayout.this.myContainer, this.myContainer, context, mainArea);
                        }
                        return null;
                    }
                };
            }
            RadLayout radLayout = this.myCaptionColumnLayout;
            if (radLayout == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/table/RadTableLayout", "getCaptionLayout"));
            }
            return radLayout;
        }
        if (this.myCaptionRowLayout == null) {
            this.myCaptionRowLayout = new RadViewLayout(){

                public EditOperation processChildOperation(OperationContext context) {
                    if (context.isMove()) {
                        return new TableVerticalCaptionOperation((RadTableLayoutComponent)RadTableLayout.this.myContainer, this.myContainer, context, mainArea);
                    }
                    return null;
                }
            };
        }
        RadLayout radLayout = this.myCaptionRowLayout;
        if (radLayout == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/table/RadTableLayout", "getCaptionLayout"));
        }
        return radLayout;
    }
}

