/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.augment;

import com.android.resources.ResourceType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import org.jetbrains.android.augment.AndroidLightClassBase;
import org.jetbrains.android.augment.ResourceTypeClassBase;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.SystemResourceManager;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidInternalRClass
extends AndroidLightClassBase {
    private static final Key<Sdk> ANDROID_INTERNAL_R = Key.create((String)"ANDROID_INTERNAL_R");
    private final PsiFile myFile;
    private final ResourceManager mySystemResourceManager;
    private final PsiClass[] myInnerClasses;

    public AndroidInternalRClass(@NotNull PsiManager psiManager, @NotNull AndroidPlatform platform, Sdk sdk) {
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "org/jetbrains/android/augment/AndroidInternalRClass", "<init>"));
        }
        if (platform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platform", "org/jetbrains/android/augment/AndroidInternalRClass", "<init>"));
        }
        super(psiManager);
        this.myFile = PsiFileFactory.getInstance((Project)this.myManager.getProject()).createFileFromText("R.java", (FileType)JavaFileType.INSTANCE, (CharSequence)"");
        this.myFile.getViewProvider().getVirtualFile().putUserData(ANDROID_INTERNAL_R, (Object)sdk);
        this.mySystemResourceManager = new SystemResourceManager(psiManager.getProject(), platform, false);
        ResourceType[] types = ResourceType.values();
        this.myInnerClasses = new PsiClass[types.length];
        for (int i = 0; i < types.length; ++i) {
            this.myInnerClasses[i] = new MyInnerClass(types[i].getName());
        }
    }

    public String toString() {
        return "AndroidInternalRClass";
    }

    @Nullable
    public String getQualifiedName() {
        return "com.android.internal.R";
    }

    public String getName() {
        return "R";
    }

    @Nullable
    public PsiClass getContainingClass() {
        return null;
    }

    @Override
    @Nullable
    public PsiFile getContainingFile() {
        return this.myFile;
    }

    @Override
    @NotNull
    public PsiClass[] getInnerClasses() {
        if (this.myInnerClasses == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/augment/AndroidInternalRClass", "getInnerClasses"));
        }
        return this.myInnerClasses;
    }

    @Override
    public PsiClass findInnerClassByName(@NonNls String name, boolean checkBases) {
        for (PsiClass aClass : this.getInnerClasses()) {
            if (!name.equals(aClass.getName())) continue;
            return aClass;
        }
        return null;
    }

    public static boolean isAndroidInternalR(@NotNull VirtualFile file, @NotNull Sdk sdk) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/augment/AndroidInternalRClass", "isAndroidInternalR"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/android/augment/AndroidInternalRClass", "isAndroidInternalR"));
        }
        return sdk.equals(file.getUserData(ANDROID_INTERNAL_R));
    }

    private class MyInnerClass
    extends ResourceTypeClassBase {
        public MyInnerClass(String name) {
            super(AndroidInternalRClass.this, name);
        }

        @Override
        @NotNull
        protected PsiField[] doGetFields() {
            PsiField[] psiFieldArray = MyInnerClass.buildResourceFields(AndroidInternalRClass.this.mySystemResourceManager, false, this.myName, AndroidInternalRClass.this);
            if (psiFieldArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/augment/AndroidInternalRClass$MyInnerClass", "doGetFields"));
            }
            return psiFieldArray;
        }
    }
}

