/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProblemData {
    private final Issue myIssue;
    private final String myMessage;
    private final TextRange myTextRange;
    private final Severity myConfiguredSeverity;

    ProblemData(@NotNull Issue issue, @NotNull String message, @NotNull TextRange textRange, @Nullable Severity configuredSeverity) {
        if (issue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "issue", "org/jetbrains/android/inspections/lint/ProblemData", "<init>"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/android/inspections/lint/ProblemData", "<init>"));
        }
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "org/jetbrains/android/inspections/lint/ProblemData", "<init>"));
        }
        this.myIssue = issue;
        this.myTextRange = textRange;
        this.myMessage = message;
        this.myConfiguredSeverity = configuredSeverity;
    }

    @NotNull
    public Issue getIssue() {
        Issue issue = this.myIssue;
        if (issue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/ProblemData", "getIssue"));
        }
        return issue;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/ProblemData", "getTextRange"));
        }
        return textRange;
    }

    @NotNull
    public String getMessage() {
        String string = this.myMessage;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/ProblemData", "getMessage"));
        }
        return string;
    }

    @Nullable
    public Severity getConfiguredSeverity() {
        return this.myConfiguredSeverity;
    }
}

