/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.android.ddmlib.MultiLineReceiver;
import org.jetbrains.annotations.NotNull;

public abstract class AndroidOutputReceiver
extends MultiLineReceiver {
    private static final String BAD_ACCESS_ERROR = "Bad address (14)";
    private boolean myTryAgain;

    public AndroidOutputReceiver() {
        this.setTrimLine(false);
    }

    public void processNewLines(String[] lines) {
        if (this.myTryAgain) {
            return;
        }
        for (String line : lines) {
            this.processNewLine(line);
            if (!line.contains(BAD_ACCESS_ERROR)) continue;
            this.myTryAgain = true;
            break;
        }
    }

    public boolean isTryAgain() {
        return this.myTryAgain;
    }

    public void invalidate() {
        this.myTryAgain = false;
    }

    protected abstract void processNewLine(@NotNull String var1);
}

