/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.tasks.TaskManager;

public class AssociateWithTaskAction
extends ToggleAction
implements DumbAware {
    public void update(AnActionEvent e) {
        boolean isChangelist = e.getData(VcsDataKeys.CHANGE_LISTS) == null;
        e.getPresentation().setVisible(isChangelist);
        if (isChangelist) {
            super.update(e);
        }
    }

    public boolean isSelected(AnActionEvent e) {
        ChangeList[] lists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        if (lists == null) {
            return false;
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        TaskManager manager = TaskManager.getManager((Project)project);
        for (ChangeList list : lists) {
            if (!(list instanceof LocalChangeList) || manager.getAssociatedTask((LocalChangeList)list) != null) continue;
            return false;
        }
        return true;
    }

    public void setSelected(AnActionEvent e, boolean state) {
        ChangeList[] lists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        if (lists == null) {
            return;
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        TaskManager manager = TaskManager.getManager((Project)project);
        for (ChangeList list : lists) {
            if (!(list instanceof LocalChangeList)) continue;
            manager.trackContext((LocalChangeList)list);
        }
    }
}

