/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.redmine;

import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.redmine.RedmineRepository;
import com.intellij.tasks.redmine.model.RedmineIssue;
import com.intellij.tasks.redmine.model.RedmineProject;
import icons.TasksIcons;
import java.util.Date;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedmineTask
extends Task {
    private final RedmineIssue myIssue;
    private final RedmineRepository myRepository;
    private final RedmineProject myProject;

    public RedmineTask(@NotNull RedmineRepository repository, @NotNull RedmineIssue issue) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/tasks/redmine/RedmineTask", "<init>"));
        }
        if (issue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "issue", "com/intellij/tasks/redmine/RedmineTask", "<init>"));
        }
        this.myIssue = issue;
        this.myRepository = repository;
        RedmineProject project = null;
        for (RedmineProject p : repository.getProjects()) {
            if (issue.getProject() == null || p.getId() != issue.getProject().getId()) continue;
            project = p;
            break;
        }
        this.myProject = project;
    }

    @NotNull
    public String getId() {
        String string = String.valueOf(this.myIssue.getId());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/redmine/RedmineTask", "getId"));
        }
        return string;
    }

    @NotNull
    public String getSummary() {
        String string = this.myIssue.getSubject();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/redmine/RedmineTask", "getSummary"));
        }
        return string;
    }

    @Nullable
    public String getDescription() {
        return this.myIssue.getDescription();
    }

    @NotNull
    public Comment[] getComments() {
        if (Comment.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/redmine/RedmineTask", "getComments"));
        }
        return Comment.EMPTY_ARRAY;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = TasksIcons.Redmine;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/redmine/RedmineTask", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public TaskType getType() {
        TaskType taskType = TaskType.BUG;
        if (taskType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/redmine/RedmineTask", "getType"));
        }
        return taskType;
    }

    @Nullable
    public Date getUpdated() {
        return this.myIssue.getUpdated();
    }

    @Nullable
    public Date getCreated() {
        return this.myIssue.getCreated();
    }

    public boolean isClosed() {
        String name = this.myIssue.getStatus().getName();
        return name.equals("Closed") || name.equals("Resolved");
    }

    public boolean isIssue() {
        return true;
    }

    @Nullable
    public String getIssueUrl() {
        return this.myRepository.getRestApiUrl("issues", this.getId());
    }

    @NotNull
    public String getNumber() {
        String string = this.getId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/redmine/RedmineTask", "getNumber"));
        }
        return string;
    }

    @Nullable
    public String getProject() {
        return this.myProject == null ? null : this.myProject.getIdentifier();
    }

    @Nullable
    public TaskRepository getRepository() {
        return this.myRepository;
    }
}

