/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.schema;

import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.schema.Constant;
import com.android.tools.rpclib.schema.Type;
import com.intellij.util.containers.HashMap;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class ConstantSet {
    private Type mType;
    private Constant[] mEntries;
    private static final HashMap<Type, ConstantSet> mRegistry = new HashMap();

    public static void register(ConstantSet set) {
        mRegistry.put((Object)set.getType(), (Object)set);
    }

    public static ConstantSet lookup(Type type) {
        return (ConstantSet)mRegistry.get((Object)type);
    }

    public ConstantSet(@NotNull Decoder d) throws IOException {
        if (d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/android/tools/rpclib/schema/ConstantSet", "<init>"));
        }
        this.mType = Type.decode(d);
        this.mEntries = new Constant[d.uint32()];
        for (int i = 0; i < this.mEntries.length; ++i) {
            this.mEntries[i] = new Constant();
            this.mEntries[i].mName = d.string();
            this.mEntries[i].mValue = this.mType.decodeValue(d);
        }
    }

    public Type getType() {
        return this.mType;
    }

    public Constant[] getEntries() {
        return this.mEntries;
    }

    public void encode(@NotNull Encoder e) throws IOException {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/rpclib/schema/ConstantSet", "encode"));
        }
        this.mType.encode(e);
        for (Constant mEntry : this.mEntries) {
            e.string(mEntry.mName);
            this.mType.encodeValue(e, mEntry.mValue);
        }
    }
}

