/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match;

import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesModel;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesValidator;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementSectionRuleManager;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementSectionRulesValidator
extends ArrangementMatchingRulesValidator {
    private ArrangementSectionRuleManager mySectionRuleManager;

    public ArrangementSectionRulesValidator(ArrangementMatchingRulesModel model, ArrangementSectionRuleManager sectionRuleManager) {
        super(model);
        this.mySectionRuleManager = sectionRuleManager;
    }

    @Override
    @Nullable
    protected String validate(int index) {
        ArrangementSectionRuleManager.ArrangementSectionRuleData data;
        if (this.myRulesModel.getSize() < index) {
            return null;
        }
        if (this.mySectionRuleManager != null && (data = this.extractSectionText(index)) != null) {
            return this.validateSectionRule(data, index);
        }
        return super.validate(index);
    }

    @Nullable
    private String validateSectionRule(@NotNull ArrangementSectionRuleManager.ArrangementSectionRuleData data, int index) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRulesValidator", "validateSectionRule"));
        }
        int startSectionIndex = -1;
        HashSet sectionRules = ContainerUtil.newHashSet();
        for (int i = 0; i < index; ++i) {
            ArrangementSectionRuleManager.ArrangementSectionRuleData section = this.extractSectionText(i);
            if (section == null) continue;
            int n = startSectionIndex = section.isSectionStart() ? i : -1;
            if (!StringUtil.isNotEmpty((String)section.getText())) continue;
            sectionRules.add(section.getText());
        }
        if (StringUtil.isNotEmpty((String)data.getText()) && sectionRules.contains(data.getText())) {
            return ApplicationBundle.message((String)"arrangement.settings.validation.duplicate.section.text", (Object[])new Object[0]);
        }
        if (!data.isSectionStart()) {
            if (startSectionIndex == -1) {
                return ApplicationBundle.message((String)"arrangement.settings.validation.end.section.rule.without.start", (Object[])new Object[0]);
            }
            if (startSectionIndex == index - 1) {
                return ApplicationBundle.message((String)"arrangement.settings.validation.empty.section.rule", (Object[])new Object[0]);
            }
        }
        return null;
    }

    @Nullable
    private ArrangementSectionRuleManager.ArrangementSectionRuleData extractSectionText(int i) {
        Object element = this.myRulesModel.getElementAt(i);
        if (element instanceof StdArrangementMatchRule) {
            assert (this.mySectionRuleManager != null);
            return this.mySectionRuleManager.getSectionRuleData((StdArrangementMatchRule)element);
        }
        return null;
    }
}

