/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class CollectConversion {
    CollectConversion() {
    }

    static void addCollectConversion(PsiReferenceExpression ref, Collection<ExpectedTypeInfo> expectedTypes, Consumer<LookupElement> consumer) {
        PsiType component;
        PsiExpression qualifier = ref.getQualifierExpression();
        PsiType psiType = component = qualifier == null ? null : PsiUtil.substituteTypeParameter((PsiType)qualifier.getType(), (String)"java.util.stream.Stream", (int)0, (boolean)true);
        if (component == null) {
            return;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)ref.getProject());
        PsiElementFactory factory = facade.getElementFactory();
        GlobalSearchScope scope = ref.getResolveScope();
        PsiClass list = facade.findClass("java.util.List", scope);
        PsiClass set = facade.findClass("java.util.Set", scope);
        PsiClass collection = facade.findClass("java.util.Collection", scope);
        if (facade.findClass("java.util.stream.Collectors", scope) == null || list == null || set == null || collection == null) {
            return;
        }
        PsiClassType listType = null;
        PsiClassType setType = null;
        boolean hasIterable = false;
        for (ExpectedTypeInfo info : expectedTypes) {
            PsiType type = info.getDefaultType();
            PsiClass expectedClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
            PsiType expectedComponent = PsiUtil.extractIterableTypeParameter((PsiType)type, (boolean)true);
            if (expectedClass == null || expectedComponent == null || !TypeConversionUtil.isAssignable((PsiType)expectedComponent, (PsiType)component)) continue;
            hasIterable = true;
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)list, (PsiClass)expectedClass, (boolean)true)) {
                listType = type;
            }
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)set, (PsiClass)expectedClass, (boolean)true)) continue;
            setType = type;
        }
        if (expectedTypes.isEmpty()) {
            listType = factory.createType(list, component);
            setType = factory.createType(set, component);
        }
        if (listType != null) {
            consumer.consume((Object)new MyLookupElement("toList", (PsiType)listType));
        }
        if (setType != null) {
            consumer.consume((Object)new MyLookupElement("toSet", (PsiType)setType));
        }
        if (expectedTypes.isEmpty() || hasIterable) {
            consumer.consume((Object)new MyLookupElement("toCollection", (PsiType)factory.createType(collection, component)));
        }
    }

    private static class MyLookupElement
    extends LookupElement
    implements TypedLookupItem {
        private final String myLookupString;
        private final String myTypeText;
        private final String myMethodName;
        @NotNull
        private final PsiType myExpectedType;

        MyLookupElement(String methodName, @NotNull PsiType expectedType) {
            if (expectedType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "com/intellij/codeInsight/completion/CollectConversion$MyLookupElement", "<init>"));
            }
            this.myMethodName = methodName;
            this.myExpectedType = expectedType;
            this.myLookupString = "collect(Collectors." + this.myMethodName + "())";
            this.myTypeText = this.myExpectedType.getPresentableText();
        }

        @NotNull
        public String getLookupString() {
            String string = this.myLookupString;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CollectConversion$MyLookupElement", "getLookupString"));
            }
            return string;
        }

        public Set<String> getAllLookupStrings() {
            return ContainerUtil.newHashSet((Object[])new String[]{this.myLookupString, this.myMethodName});
        }

        public void renderElement(LookupElementPresentation presentation) {
            super.renderElement(presentation);
            presentation.setTypeText(this.myTypeText);
            presentation.setIcon(PlatformIcons.METHOD_ICON);
        }

        public void handleInsert(InsertionContext context) {
            context.getDocument().replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)this.getInsertString());
            context.commitDocument();
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PsiMethodCallExpression.class, (boolean)false);
            if (call == null) {
                return;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length != 1 || !(args[0] instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression innerCall = (PsiMethodCallExpression)args[0];
            PsiMethod collectorMethod = innerCall.resolveMethod();
            if (collectorMethod != null && collectorMethod.getParameterList().getParametersCount() > 0) {
                context.getEditor().getCaretModel().moveToOffset(innerCall.getArgumentList().getFirstChild().getTextRange().getEndOffset());
            }
            JavaCodeStyleManager.getInstance((Project)context.getProject()).shortenClassReferences((PsiElement)innerCall);
        }

        @NotNull
        private String getInsertString() {
            String string = "collect(java.util.stream.Collectors." + this.myMethodName + "())";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CollectConversion$MyLookupElement", "getInsertString"));
            }
            return string;
        }

        @Override
        public PsiType getType() {
            return this.myExpectedType;
        }
    }
}

