/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis.encoding;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.encoding.EncodingReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttributeValue;
import org.jetbrains.annotations.NotNull;

public class XmlEncodingReference
extends EncodingReference
implements EmptyResolveMessageProvider,
Comparable<XmlEncodingReference> {
    private final int myPriority;

    public XmlEncodingReference(XmlAttributeValue value, String charsetName, TextRange rangeInElement, int priority) {
        super((PsiElement)value, charsetName, rangeInElement);
        this.myPriority = priority;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = XmlErrorMessages.message("unknown.encoding.0", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/encoding/XmlEncodingReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }

    @Override
    public int compareTo(@NotNull XmlEncodingReference ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/analysis/encoding/XmlEncodingReference", "compareTo"));
        }
        return this.myPriority - ref.myPriority;
    }
}

