/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.content.Content;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.Producer;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickDocUtil {
    public static void updateQuickDocAsync(final @NotNull PsiElement element, final @NotNull Producer<String> docProducer) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/documentation/QuickDocUtil", "updateQuickDocAsync"));
        }
        if (docProducer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docProducer", "com/intellij/codeInsight/documentation/QuickDocUtil", "updateQuickDocAsync"));
        }
        final Project project2 = element.getProject();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                QuickDocUtil.updateQuickDoc(project2, element, (String)docProducer.produce());
            }
        });
    }

    public static void updateQuickDoc(final @NotNull Project project2, final @NotNull PsiElement element, final @Nullable String documentation) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/documentation/QuickDocUtil", "updateQuickDoc"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/documentation/QuickDocUtil", "updateQuickDoc"));
        }
        if (StringUtil.isEmpty((String)documentation)) {
            return;
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                DocumentationComponent component = QuickDocUtil.getActiveDocComponent(project2);
                if (component != null) {
                    component.replaceText(documentation, element);
                }
            }
        });
    }

    @Nullable
    public static DocumentationComponent getActiveDocComponent(@NotNull Project project2) {
        DocumentationComponent component;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/documentation/QuickDocUtil", "getActiveDocComponent"));
        }
        DocumentationManager documentationManager = DocumentationManager.getInstance(project2);
        JBPopup hint = documentationManager.getDocInfoHint();
        if (hint != null) {
            component = (DocumentationComponent)((AbstractPopup)hint).getComponent();
        } else if (documentationManager.hasActiveDockedDocWindow()) {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.DOCUMENTATION);
            Content selectedContent = toolWindow == null ? null : toolWindow.getContentManager().getSelectedContent();
            component = selectedContent == null ? null : (DocumentationComponent)selectedContent.getComponent();
        } else {
            component = null;
        }
        return component;
    }

    /*
     * WARNING - void declaration
     */
    static boolean runInReadActionWithWriteActionPriorityWithRetries(@NotNull Runnable action, long timeout, long pauseBetweenRetries, @Nullable ProgressIndicator progressIndicator) {
        void progressIndicator2;
        boolean result;
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/documentation/QuickDocUtil", "runInReadActionWithWriteActionPriorityWithRetries"));
        }
        long deadline = System.currentTimeMillis() + timeout;
        while (!((result = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(action, progressIndicator2 == null ? null : new SensitiveProgressWrapper((ProgressIndicator)progressIndicator2))) || progressIndicator2 != null && progressIndicator2.isCanceled() || System.currentTimeMillis() >= deadline)) {
            try {
                TimeUnit.MILLISECONDS.sleep(pauseBetweenRetries);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return result;
    }
}

