/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.xml.XmlTokenImpl;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementDescriptorWithCDataContent;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.Collection;

public class XmlGtTypedHandler
extends TypedHandlerDelegate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.TypedHandler");

    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project2, Editor editor, PsiFile editedFile, FileType fileType) {
        WebEditorOptions webEditorOptions = WebEditorOptions.getInstance();
        if (c == '>' && webEditorOptions != null && webEditorOptions.isAutomaticallyInsertClosingTag() && XmlGtTypedHandler.fileContainsXmlLanguage(editedFile)) {
            PsiElement element;
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
            FileViewProvider provider = editedFile.getViewProvider();
            int offset = editor.getCaretModel().getOffset();
            PsiElement elementAtCaret = null;
            if (offset < editor.getDocument().getTextLength()) {
                PsiElement parent;
                IElementType tokenType;
                elementAtCaret = element = provider.findElementAt(offset, XMLLanguage.class);
                if (element == null && offset > 0) {
                    elementAtCaret = element = provider.findElementAt(offset - 1, XMLLanguage.class);
                }
                if (!(element instanceof PsiWhiteSpace)) {
                    boolean nonAcceptableDelimiter = true;
                    if (element instanceof XmlToken) {
                        tokenType = ((XmlToken)element).getTokenType();
                        if (tokenType == XmlTokenType.XML_START_TAG_START || tokenType == XmlTokenType.XML_END_TAG_START) {
                            PsiElement previousElement;
                            if (offset > 0 && (previousElement = provider.findElementAt(offset - 1, XMLLanguage.class)) instanceof XmlToken) {
                                tokenType = ((XmlToken)previousElement).getTokenType();
                                element = previousElement;
                                nonAcceptableDelimiter = false;
                            }
                        } else if ((tokenType == XmlTokenType.XML_NAME || tokenType == XmlTokenType.XML_TAG_NAME) && element.getNextSibling() instanceof PsiErrorElement) {
                            nonAcceptableDelimiter = false;
                        }
                        if (tokenType == XmlTokenType.XML_TAG_END || tokenType == XmlTokenType.XML_EMPTY_ELEMENT_END && element.getTextOffset() == offset - 1) {
                            EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
                            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                            return TypedHandlerDelegate.Result.STOP;
                        }
                    }
                    if (nonAcceptableDelimiter) {
                        return TypedHandlerDelegate.Result.CONTINUE;
                    }
                } else {
                    PsiElement previousElement = provider.findElementAt(offset - 1, XMLLanguage.class);
                    if (previousElement instanceof XmlToken && (tokenType = ((XmlToken)previousElement).getTokenType()) == XmlTokenType.XML_EMPTY_ELEMENT_END) {
                        return TypedHandlerDelegate.Result.STOP;
                    }
                }
                if ((parent = element.getParent()) instanceof XmlText) {
                    String text = parent.getText();
                    int index = offset - parent.getTextOffset() - 1;
                    if (index >= 0 && text.charAt(index) == '/') {
                        return TypedHandlerDelegate.Result.CONTINUE;
                    }
                    element = parent.getPrevSibling();
                } else if (parent instanceof XmlTag && !(element.getPrevSibling() instanceof XmlTag) && !(element.getPrevSibling() instanceof OuterLanguageElement)) {
                    element = parent;
                } else if (parent instanceof XmlAttributeValue) {
                    element = parent;
                }
            } else {
                element = provider.findElementAt(editor.getDocument().getTextLength() - 1, XMLLanguage.class);
                if (element == null) {
                    return TypedHandlerDelegate.Result.CONTINUE;
                }
                element = element.getParent();
            }
            if (offset > 0 && offset <= editor.getDocument().getTextLength() && editor.getDocument().getCharsSequence().charAt(offset - 1) == '/') {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            if (element instanceof XmlAttributeValue) {
                element = element.getParent().getParent();
            }
            while (element instanceof PsiWhiteSpace || element instanceof OuterLanguageElement) {
                element = element.getPrevSibling();
            }
            if (element instanceof XmlDocument) {
                element = element.getLastChild();
            }
            if (element == null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            if (!(element instanceof XmlTag)) {
                if (element instanceof XmlTokenImpl && element.getPrevSibling() != null && element.getPrevSibling().getText().equals("<")) {
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)("</" + element.getText() + ">"), (boolean)false, (int)0);
                }
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            XmlTag tag = (XmlTag)element;
            if (XmlUtil.getTokenOfType((PsiElement)tag, XmlTokenType.XML_TAG_END) != null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            if (XmlUtil.getTokenOfType((PsiElement)tag, XmlTokenType.XML_EMPTY_ELEMENT_END) != null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            XmlToken startToken = XmlUtil.getTokenOfType((PsiElement)tag, XmlTokenType.XML_START_TAG_START);
            if (startToken == null || !startToken.getText().equals("<")) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            String name = tag.getName();
            if (elementAtCaret instanceof XmlToken && ((XmlToken)elementAtCaret).getTokenType() == XmlTokenType.XML_NAME) {
                name = name.substring(0, offset - elementAtCaret.getTextOffset());
            }
            if (tag instanceof HtmlTag && HtmlUtil.isSingleHtmlTag(name)) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            if (name.isEmpty()) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            int tagOffset = tag.getTextRange().getStartOffset();
            XmlToken nameToken = XmlUtil.getTokenOfType((PsiElement)tag, XmlTokenType.XML_NAME);
            if (nameToken != null && nameToken.getTextRange().getStartOffset() > offset) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(tagOffset);
            if (BraceMatchingUtil.matchBrace(editor.getDocument().getCharsSequence(), editedFile.getFileType(), iterator, true, true)) {
                PsiElement parent = tag.getParent();
                boolean hasBalance = true;
                block3: while (parent instanceof XmlTag) {
                    if (name.equals(((XmlTag)parent).getName())) {
                        hasBalance = false;
                        ASTNode astNode = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(parent.getNode());
                        if (astNode == null) {
                            hasBalance = true;
                            break;
                        }
                        for (PsiElement el = parent.getNextSibling(); el != null; el = el.getNextSibling()) {
                            if (!(el instanceof PsiErrorElement) || !el.getText().startsWith("</" + name)) continue;
                            hasBalance = true;
                            break block3;
                        }
                    }
                    parent = parent.getParent();
                }
                if (hasBalance) {
                    return TypedHandlerDelegate.Result.CONTINUE;
                }
            }
            Collection cdataReformatRanges = null;
            XmlElementDescriptor descriptor = tag.getDescriptor();
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)("</" + name + ">"), (boolean)false, (int)0);
            if (descriptor instanceof XmlElementDescriptorWithCDataContent) {
                XmlElementDescriptorWithCDataContent cDataContainer = (XmlElementDescriptorWithCDataContent)descriptor;
                cdataReformatRanges = ContainerUtil.newSmartList();
                if (cDataContainer.requiresCdataBracesInContext(tag)) {
                    String cDataStart = "><![CDATA[";
                    String inserted = "><![CDATA[\n]]>";
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"><![CDATA[\n]]>", (boolean)false, (int)"><![CDATA[".length());
                    int caretOffset = editor.getCaretModel().getOffset();
                    if (caretOffset >= "><![CDATA[".length()) {
                        cdataReformatRanges.add(TextRange.from((int)(caretOffset - "><![CDATA[".length()), (int)("><![CDATA[\n]]>".length() + 1)));
                    }
                }
            }
            if (cdataReformatRanges != null && !cdataReformatRanges.isEmpty()) {
                PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
                try {
                    CodeStyleManager.getInstance((Project)project2).reformatText(file2, cdataReformatRanges);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            return cdataReformatRanges != null && !cdataReformatRanges.isEmpty() ? TypedHandlerDelegate.Result.STOP : TypedHandlerDelegate.Result.CONTINUE;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    static boolean fileContainsXmlLanguage(PsiFile editedFile) {
        if (editedFile.getLanguage() instanceof XMLLanguage) {
            return true;
        }
        if (HtmlUtil.supportsXmlTypedHandlers(editedFile)) {
            return true;
        }
        FileViewProvider provider = editedFile.getViewProvider();
        if (provider.getBaseLanguage() instanceof XMLLanguage) {
            return true;
        }
        return provider instanceof TemplateLanguageFileViewProvider && ((TemplateLanguageFileViewProvider)provider).getTemplateDataLanguage() instanceof XMLLanguage;
    }
}

