/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveUpDown;

import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaseBlockMover
extends StatementUpDownMover {
    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        LineRange range2;
        PsiElement lastToMove2;
        PsiElement firstToMove2;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/moveUpDown/CaseBlockMover", "checkAvailable"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/moveUpDown/CaseBlockMover", "checkAvailable"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/editorActions/moveUpDown/CaseBlockMover", "checkAvailable"));
        }
        if (!(file2 instanceof PsiJavaFile)) {
            return false;
        }
        PsiElement startElement = CaseBlockMover.firstNonWhiteElement((int)editor.getSelectionModel().getSelectionStart(), (PsiFile)file2, (boolean)true);
        if (startElement == null) {
            return false;
        }
        PsiElement endElement = CaseBlockMover.firstNonWhiteElement((int)editor.getSelectionModel().getSelectionEnd(), (PsiFile)file2, (boolean)false);
        if (endElement == null) {
            return false;
        }
        PsiSwitchLabelStatement caseStatement = (PsiSwitchLabelStatement)PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement), PsiSwitchLabelStatement.class, (boolean)false);
        if (caseStatement == null) {
            return false;
        }
        PsiSwitchLabelStatement firstToMove = CaseBlockMover.getThisCaseBlockStart(caseStatement);
        PsiElement nextCaseBlockStart = CaseBlockMover.getNextCaseBlockStart(caseStatement);
        PsiElement lastToMove = PsiTreeUtil.skipSiblingsBackward((PsiElement)nextCaseBlockStart, (Class[])new Class[]{PsiWhiteSpace.class});
        assert (lastToMove != null);
        LineRange range = CaseBlockMover.createRange(editor.getDocument(), (PsiElement)firstToMove, lastToMove);
        if (range == null) {
            return info.prohibitMove();
        }
        info.toMove = range;
        if (down) {
            if (!(nextCaseBlockStart instanceof PsiSwitchLabelStatement) || nextCaseBlockStart == caseStatement) {
                return info.prohibitMove();
            }
            firstToMove2 = nextCaseBlockStart;
            nextCaseBlockStart = CaseBlockMover.getNextCaseBlockStart((PsiSwitchLabelStatement)firstToMove2);
            lastToMove2 = PsiTreeUtil.skipSiblingsBackward((PsiElement)nextCaseBlockStart, (Class[])new Class[]{PsiWhiteSpace.class});
            assert (lastToMove2 != null);
        } else {
            lastToMove2 = PsiTreeUtil.skipSiblingsBackward((PsiElement)firstToMove, (Class[])new Class[]{PsiWhiteSpace.class});
            if (lastToMove2 == null) {
                return info.prohibitMove();
            }
            firstToMove2 = PsiTreeUtil.getPrevSiblingOfType((PsiElement)lastToMove2, PsiSwitchLabelStatement.class);
            if (firstToMove2 == null) {
                return info.prohibitMove();
            }
            firstToMove2 = CaseBlockMover.getThisCaseBlockStart((PsiSwitchLabelStatement)firstToMove2);
        }
        if ((range2 = CaseBlockMover.createRange(editor.getDocument(), firstToMove2, lastToMove2)) == null) {
            return info.prohibitMove();
        }
        info.toMove2 = range2;
        return true;
    }

    @NotNull
    private static PsiSwitchLabelStatement getThisCaseBlockStart(PsiSwitchLabelStatement element) {
        PsiElement tmp;
        while ((tmp = PsiTreeUtil.skipSiblingsBackward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class})) instanceof PsiSwitchLabelStatement) {
            element = (PsiSwitchLabelStatement)tmp;
        }
        PsiSwitchLabelStatement psiSwitchLabelStatement = element;
        if (psiSwitchLabelStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/moveUpDown/CaseBlockMover", "getThisCaseBlockStart"));
        }
        return psiSwitchLabelStatement;
    }

    @NotNull
    private static PsiElement getNextCaseBlockStart(PsiSwitchLabelStatement element) {
        PsiElement tmp;
        PsiSwitchLabelStatement result = element;
        while ((tmp = PsiTreeUtil.skipSiblingsForward((PsiElement)result, (Class[])new Class[]{PsiWhiteSpace.class})) instanceof PsiSwitchLabelStatement) {
            result = tmp;
        }
        tmp = PsiTreeUtil.getNextSiblingOfType((PsiElement)result, PsiSwitchLabelStatement.class);
        PsiElement psiElement = tmp == null ? result.getParent().getLastChild() : tmp;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/moveUpDown/CaseBlockMover", "getNextCaseBlockStart"));
        }
        return psiElement;
    }

    @Nullable
    private static LineRange createRange(@NotNull Document document, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        int endLine;
        int startOffset;
        int startLine;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/editorActions/moveUpDown/CaseBlockMover", "createRange"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/editorActions/moveUpDown/CaseBlockMover", "createRange"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/editorActions/moveUpDown/CaseBlockMover", "createRange"));
        }
        CharSequence text = document.getImmutableCharSequence();
        if (!CharArrayUtil.isEmptyOrSpaces((CharSequence)text, (int)document.getLineStartOffset(startLine = document.getLineNumber(startOffset = startElement.getTextRange().getStartOffset())), (int)startOffset)) {
            return null;
        }
        int endOffset = endElement.getTextRange().getEndOffset();
        if (!CharArrayUtil.isEmptyOrSpaces((CharSequence)text, (int)endOffset, (int)document.getLineEndOffset(endLine = document.getLineNumber(endOffset)))) {
            return null;
        }
        return new LineRange(startLine, endLine + 1);
    }
}

