/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingPolicy;
import com.intellij.codeInsight.folding.impl.FoldingUpdate;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class UpdateFoldRegionsOperation
implements Runnable {
    private static final Logger LOG = Logger.getInstance((String)("#" + UpdateFoldRegionsOperation.class.getName()));
    private static final Key<Boolean> CAN_BE_REMOVED_WHEN_COLLAPSED = Key.create((String)"canBeRemovedWhenCollapsed");
    private final Project myProject;
    private final Editor myEditor;
    private final PsiFile myFile;
    private final ApplyDefaultStateMode myApplyDefaultState;
    private final FoldingUpdate.FoldingMap myElementsToFoldMap;
    private final boolean myKeepCollapsedRegions;
    private final boolean myForInjected;

    UpdateFoldRegionsOperation(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull FoldingUpdate.FoldingMap elementsToFoldMap, ApplyDefaultStateMode applyDefaultState, boolean keepCollapsedRegions, boolean forInjected) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "<init>"));
        }
        if (elementsToFoldMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsToFoldMap", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "<init>"));
        }
        this.myProject = project2;
        this.myEditor = editor;
        this.myFile = file2;
        this.myApplyDefaultState = applyDefaultState;
        this.myElementsToFoldMap = elementsToFoldMap;
        this.myKeepCollapsedRegions = keepCollapsedRegions;
        this.myForInjected = forInjected;
    }

    @Override
    public void run() {
        EditorFoldingInfo info = EditorFoldingInfo.get(this.myEditor);
        FoldingModelEx foldingModel = (FoldingModelEx)this.myEditor.getFoldingModel();
        THashMap rangeToExpandStatusMap = ContainerUtil.newTroveMap();
        FoldingUpdate.FoldingMap elementsToFold = new FoldingUpdate.FoldingMap(this.myElementsToFoldMap);
        this.removeInvalidRegions(info, foldingModel, elementsToFold, (Map<TextRange, Boolean>)rangeToExpandStatusMap);
        THashMap shouldExpand = ContainerUtil.newTroveMap();
        THashMap groupExpand = ContainerUtil.newTroveMap();
        List<FoldRegion> newRegions = this.addNewRegions(info, foldingModel, elementsToFold, (Map<TextRange, Boolean>)rangeToExpandStatusMap, (Map<FoldRegion, Boolean>)shouldExpand, (Map<FoldingGroup, Boolean>)groupExpand);
        UpdateFoldRegionsOperation.applyExpandStatus(newRegions, (Map<FoldRegion, Boolean>)shouldExpand, (Map<FoldingGroup, Boolean>)groupExpand);
        foldingModel.clearDocumentRangesModificationStatus();
    }

    private static void applyExpandStatus(@NotNull List<FoldRegion> newRegions, @NotNull Map<FoldRegion, Boolean> shouldExpand, @NotNull Map<FoldingGroup, Boolean> groupExpand) {
        if (newRegions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRegions", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "applyExpandStatus"));
        }
        if (shouldExpand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shouldExpand", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "applyExpandStatus"));
        }
        if (groupExpand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupExpand", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "applyExpandStatus"));
        }
        for (FoldRegion region : newRegions) {
            FoldingGroup group = region.getGroup();
            Boolean expanded = group == null ? shouldExpand.get(region) : groupExpand.get(group);
            if (expanded == null) continue;
            region.setExpanded(expanded.booleanValue());
        }
    }

    private List<FoldRegion> addNewRegions(@NotNull EditorFoldingInfo info, @NotNull FoldingModelEx foldingModel, FoldingUpdate.FoldingMap elementsToFold, @NotNull Map<TextRange, Boolean> rangeToExpandStatusMap, @NotNull Map<FoldRegion, Boolean> shouldExpand, @NotNull Map<FoldingGroup, Boolean> groupExpand) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "addNewRegions"));
        }
        if (foldingModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldingModel", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "addNewRegions"));
        }
        if (rangeToExpandStatusMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeToExpandStatusMap", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "addNewRegions"));
        }
        if (shouldExpand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shouldExpand", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "addNewRegions"));
        }
        if (groupExpand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupExpand", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "addNewRegions"));
        }
        ArrayList newRegions = ContainerUtil.newArrayList();
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
        for (PsiElement element : elementsToFold.keySet()) {
            ProgressManager.checkCanceled();
            Collection descriptors = elementsToFold.get(element);
            for (FoldingDescriptor descriptor : descriptors) {
                boolean expandStatus;
                FoldingGroup group = descriptor.getGroup();
                TextRange range = descriptor.getRange();
                String placeholder = descriptor.getPlaceholderText();
                if (range.getEndOffset() > this.myEditor.getDocument().getTextLength()) {
                    LOG.error(String.format("Invalid folding descriptor detected (%s). It ends beyond the document range (%d)", descriptor, this.myEditor.getDocument().getTextLength()));
                    continue;
                }
                FoldRegion region = foldingModel.createFoldRegion(range.getStartOffset(), range.getEndOffset(), placeholder == null ? "..." : placeholder, group, descriptor.isNonExpandable());
                if (region == null) continue;
                PsiElement psi = descriptor.getElement().getPsi();
                if (!(psi != null && psi.isValid() && foldingModel.addFoldRegion(region) && this.myFile.isValid())) {
                    region.dispose();
                    continue;
                }
                if (descriptor.canBeRemovedWhenCollapsed()) {
                    region.putUserData(CAN_BE_REMOVED_WHEN_COLLAPSED, (Object)Boolean.TRUE);
                }
                info.addRegion(region, smartPointerManager.createSmartPsiElementPointer(psi));
                newRegions.add(region);
                boolean bl = expandStatus = !descriptor.isNonExpandable() && this.shouldExpandNewRegion(element, range, rangeToExpandStatusMap);
                if (group == null) {
                    shouldExpand.put(region, expandStatus);
                    continue;
                }
                Boolean alreadyExpanded = groupExpand.get(group);
                groupExpand.put(group, alreadyExpanded == null ? expandStatus : alreadyExpanded != false || expandStatus);
            }
        }
        return newRegions;
    }

    private boolean shouldExpandNewRegion(PsiElement element, TextRange range, Map<TextRange, Boolean> rangeToExpandStatusMap) {
        if (this.myApplyDefaultState != ApplyDefaultStateMode.NO) {
            TextRange lineRange;
            if (this.myApplyDefaultState == ApplyDefaultStateMode.EXCEPT_CARET_REGION && (lineRange = OpenFileDescriptor.getRangeToUnfoldOnNavigation((Editor)this.myEditor)).intersects(range)) {
                return true;
            }
            return !FoldingPolicy.isCollapseByDefault(element);
        }
        Boolean oldStatus = rangeToExpandStatusMap.get(range);
        return oldStatus == null || FoldingUtil.caretInsideRange(this.myEditor, range) || oldStatus != false;
    }

    private void removeInvalidRegions(@NotNull EditorFoldingInfo info, @NotNull FoldingModelEx foldingModel, FoldingUpdate.FoldingMap elementsToFold, @NotNull Map<TextRange, Boolean> rangeToExpandStatusMap) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "removeInvalidRegions"));
        }
        if (foldingModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldingModel", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "removeInvalidRegions"));
        }
        if (rangeToExpandStatusMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeToExpandStatusMap", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "removeInvalidRegions"));
        }
        ArrayList toRemove = ContainerUtil.newArrayList();
        InjectedLanguageManager injectedManager = InjectedLanguageManager.getInstance((Project)this.myProject);
        for (FoldRegion region : foldingModel.getAllFoldRegions()) {
            Collection descriptors;
            PsiFile containingFile;
            boolean isInjected;
            PsiElement element;
            if (this.myKeepCollapsedRegions && !region.isExpanded() && !this.regionOrGroupCanBeRemovedWhenCollapsed(region) || (element = info.getPsiElement(region)) != null && (isInjected = injectedManager.isInjectedFragment(containingFile = element.getContainingFile())) != this.myForInjected) continue;
            if (element != null && !(descriptors = elementsToFold.get(element)).isEmpty()) {
                boolean matchingDescriptorFound = false;
                FoldingDescriptor[] array = descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
                for (FoldingDescriptor descriptor : array) {
                    TextRange range = descriptor.getRange();
                    if (!TextRange.areSegmentsEqual((Segment)region, (Segment)range)) continue;
                    matchingDescriptorFound = true;
                    if (!region.isValid() || region.getGroup() != null || descriptor.getGroup() != null || !region.getPlaceholderText().equals(descriptor.getPlaceholderText()) || range.getLength() < 2) {
                        rangeToExpandStatusMap.put(range, region.isExpanded());
                        toRemove.add(region);
                        break;
                    }
                    elementsToFold.remove(element, descriptor);
                }
                if (matchingDescriptorFound) continue;
                if (Registry.is((String)"editor.durable.folding.state")) {
                    for (FoldingDescriptor descriptor : descriptors) {
                        rangeToExpandStatusMap.put(descriptor.getRange(), region.isExpanded());
                    }
                }
                toRemove.add(region);
                continue;
            }
            if (region.isValid() && info.isLightRegion(region)) {
                boolean isExpanded = region.isExpanded();
                rangeToExpandStatusMap.put(TextRange.create((Segment)region), isExpanded);
                continue;
            }
            toRemove.add(region);
        }
        for (FoldRegion region : toRemove) {
            foldingModel.removeFoldRegion(region);
            info.removeRegion(region);
        }
    }

    private boolean regionOrGroupCanBeRemovedWhenCollapsed(FoldRegion region) {
        FoldingGroup group = region.getGroup();
        List<FoldRegion> affectedRegions = group != null && this.myEditor instanceof EditorEx ? ((EditorEx)this.myEditor).getFoldingModel().getGroupedRegions(group) : Collections.singletonList(region);
        for (FoldRegion affectedRegion : affectedRegions) {
            if (!this.regionCanBeRemovedWhenCollapsed(affectedRegion)) continue;
            return true;
        }
        return false;
    }

    private boolean regionCanBeRemovedWhenCollapsed(FoldRegion region) {
        return Boolean.TRUE.equals(region.getUserData(CAN_BE_REMOVED_WHEN_COLLAPSED)) || ((FoldingModelEx)this.myEditor.getFoldingModel()).hasDocumentRegionChangedFor(region) || !region.isValid() || this.isRegionInCaretLine(region);
    }

    private boolean isRegionInCaretLine(FoldRegion region) {
        int regionStartLine = this.myEditor.getDocument().getLineNumber(region.getStartOffset());
        int regionEndLine = this.myEditor.getDocument().getLineNumber(region.getEndOffset());
        int caretLine = this.myEditor.getCaretModel().getLogicalPosition().line;
        return caretLine >= regionStartLine && caretLine <= regionEndLine;
    }

    static enum ApplyDefaultStateMode {
        YES,
        EXCEPT_CARET_REGION,
        NO;

    }
}

