/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiFile;

public class CodeInspectionOnEditorAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return;
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile != null) {
            CodeInspectionOnEditorAction.analyze(project2, psiFile);
        }
    }

    protected static void analyze(Project project2, PsiFile psiFile) {
        FileDocumentManager.getInstance().saveAllDocuments();
        InspectionManagerEx inspectionManagerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)project2);
        AnalysisScope scope = new AnalysisScope(psiFile);
        GlobalInspectionContextImpl inspectionContext = inspectionManagerEx.createNewGlobalContext(false);
        inspectionContext.setCurrentScope(scope);
        InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance(project2).getInspectionProfile();
        inspectionContext.setExternalProfile(inspectionProfile);
        inspectionContext.doInspections(scope);
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        e.getPresentation().setEnabled(project2 != null && psiFile != null && DaemonCodeAnalyzer.getInstance((Project)project2).isHighlightingAvailable(psiFile));
    }
}

