/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant.artifacts;

import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.Tag;
import com.intellij.compiler.ant.taskdefs.Copy;
import com.intellij.compiler.ant.taskdefs.FileSet;
import com.intellij.compiler.ant.taskdefs.Mkdir;
import com.intellij.compiler.ant.taskdefs.Unzip;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import org.jetbrains.annotations.NotNull;

public class DirectoryAntCopyInstructionCreator
implements AntCopyInstructionCreator {
    private final String myOutputDirectory;

    public DirectoryAntCopyInstructionCreator(String outputDirectory) {
        this.myOutputDirectory = outputDirectory;
    }

    public String getOutputDirectory() {
        return this.myOutputDirectory;
    }

    @NotNull
    public Tag createDirectoryContentCopyInstruction(@NotNull String dirPath) {
        if (dirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirPath", "com/intellij/compiler/ant/artifacts/DirectoryAntCopyInstructionCreator", "createDirectoryContentCopyInstruction"));
        }
        Copy copy = new Copy(this.myOutputDirectory);
        copy.add((Generator)new FileSet(dirPath));
        Copy copy2 = copy;
        if (copy2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/ant/artifacts/DirectoryAntCopyInstructionCreator", "createDirectoryContentCopyInstruction"));
        }
        return copy2;
    }

    @NotNull
    public Tag createFileCopyInstruction(@NotNull String filePath, String outputFileName) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/compiler/ant/artifacts/DirectoryAntCopyInstructionCreator", "createFileCopyInstruction"));
        }
        Copy copy = new Copy(filePath, this.myOutputDirectory + "/" + outputFileName);
        if (copy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/ant/artifacts/DirectoryAntCopyInstructionCreator", "createFileCopyInstruction"));
        }
        return copy;
    }

    @NotNull
    public AntCopyInstructionCreator subFolder(@NotNull String directoryName) {
        if (directoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryName", "com/intellij/compiler/ant/artifacts/DirectoryAntCopyInstructionCreator", "subFolder"));
        }
        DirectoryAntCopyInstructionCreator directoryAntCopyInstructionCreator = new DirectoryAntCopyInstructionCreator(this.myOutputDirectory + "/" + directoryName);
        if (directoryAntCopyInstructionCreator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/ant/artifacts/DirectoryAntCopyInstructionCreator", "subFolder"));
        }
        return directoryAntCopyInstructionCreator;
    }

    public Generator createSubFolderCommand(@NotNull String directoryName) {
        if (directoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryName", "com/intellij/compiler/ant/artifacts/DirectoryAntCopyInstructionCreator", "createSubFolderCommand"));
        }
        return new Mkdir(this.myOutputDirectory + "/" + directoryName);
    }

    @NotNull
    public Generator createExtractedDirectoryInstruction(@NotNull String jarPath) {
        if (jarPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarPath", "com/intellij/compiler/ant/artifacts/DirectoryAntCopyInstructionCreator", "createExtractedDirectoryInstruction"));
        }
        Unzip unzip = new Unzip(jarPath, this.myOutputDirectory);
        if (unzip == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/ant/artifacts/DirectoryAntCopyInstructionCreator", "createExtractedDirectoryInstruction"));
        }
        return unzip;
    }
}

