/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.AutoRendererAction;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.actions.JavaReferringObjectsValue;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewAsGroup
extends ActionGroup
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.actions.ViewAsGroup");
    private volatile AnAction[] myChildren = AnAction.EMPTY_ARRAY;

    public ViewAsGroup() {
        super(null, true);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (this.myChildren == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/ViewAsGroup", "getChildren"));
        }
        return this.myChildren;
    }

    private static AnAction[] calcChildren(List<JavaValue> values) {
        AnAction[] viewAsActions;
        ArrayList<RendererAction> renderers = new ArrayList<RendererAction>();
        List<NodeRenderer> allRenderers = NodeRendererSettings.getInstance().getAllRenderers();
        boolean anyValueDescriptor = false;
        for (NodeRenderer nodeRenderer : allRenderers) {
            boolean allApp = true;
            for (JavaValue value : values) {
                if (value instanceof JavaReferringObjectsValue) {
                    return AnAction.EMPTY_ARRAY;
                }
                ValueDescriptorImpl valueDescriptor = value.getDescriptor();
                anyValueDescriptor = true;
                if (valueDescriptor.isValueValid() && nodeRenderer.isApplicable(valueDescriptor.getType())) continue;
                allApp = false;
                break;
            }
            if (!anyValueDescriptor) {
                return AnAction.EMPTY_ARRAY;
            }
            if (!allApp) continue;
            renderers.add(new RendererAction(nodeRenderer));
        }
        ArrayList<Object> children2 = new ArrayList<Object>();
        for (AnAction viewAsAction : viewAsActions = ((DefaultActionGroup)ActionManager.getInstance().getAction("Debugger.Representation")).getChildren(null)) {
            if (viewAsAction instanceof AutoRendererAction) {
                if (renderers.size() <= 1) continue;
                viewAsAction.getTemplatePresentation().setVisible(true);
                children2.add(viewAsAction);
                continue;
            }
            children2.add(viewAsAction);
        }
        if (!children2.isEmpty()) {
            children2.add(Separator.getInstance());
        }
        children2.addAll(renderers);
        return children2.toArray(new AnAction[children2.size()]);
    }

    public void update(final AnActionEvent event) {
        if (!DebuggerAction.isFirstStart(event)) {
            return;
        }
        this.myChildren = AnAction.EMPTY_ARRAY;
        DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(event.getDataContext());
        final List<JavaValue> values = ViewAsGroup.getSelectedValues(event);
        if (values.isEmpty()) {
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        DebugProcessImpl process = debuggerContext.getDebugProcess();
        if (process == null) {
            event.getPresentation().setEnabled(false);
            return;
        }
        process.getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext){

            @Override
            public void threadAction() {
                ViewAsGroup.access$202(ViewAsGroup.this, ViewAsGroup.calcChildren(values));
                DebuggerAction.enableAction(event, ViewAsGroup.this.myChildren.length > 0);
            }
        });
    }

    public static List<JavaValue> getSelectedValues(AnActionEvent event) {
        List<XValueNodeImpl> selectedNodes = XDebuggerTreeActionBase.getSelectedNodes(event.getDataContext());
        if (selectedNodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<JavaValue> res = new ArrayList<JavaValue>(selectedNodes.size());
        for (XValueNodeImpl node : selectedNodes) {
            XValue container = (XValue)node.getValueContainer();
            if (!(container instanceof JavaValue)) continue;
            res.add((JavaValue)container);
        }
        return res;
    }

    static /* synthetic */ AnAction[] access$202(ViewAsGroup x0, AnAction[] x1) {
        x0.myChildren = x1;
        return x1;
    }

    private static class RendererAction
    extends ToggleAction {
        private final NodeRenderer myNodeRenderer;

        public RendererAction(NodeRenderer nodeRenderer) {
            super(nodeRenderer.getName());
            this.myNodeRenderer = nodeRenderer;
        }

        public boolean isSelected(AnActionEvent e) {
            List<JavaValue> values = ViewAsGroup.getSelectedValues(e);
            if (values.isEmpty()) {
                return false;
            }
            for (JavaValue value : values) {
                if (value.getDescriptor().getLastRenderer() == this.myNodeRenderer) continue;
                return false;
            }
            return true;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (!state) {
                return;
            }
            DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(e.getDataContext());
            List<JavaValue> values = ViewAsGroup.getSelectedValues(e);
            final List<XValueNodeImpl> selectedNodes = XDebuggerTreeActionBase.getSelectedNodes(e.getDataContext());
            LOG.assertTrue(!values.isEmpty());
            DebugProcessImpl process = debuggerContext.getDebugProcess();
            if (process == null) {
                return;
            }
            process.getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext){

                @Override
                public void threadAction() {
                    for (XValueNodeImpl node : selectedNodes) {
                        XValue container = (XValue)node.getValueContainer();
                        if (!(container instanceof JavaValue)) continue;
                        ((JavaValue)container).setRenderer(myNodeRenderer, node);
                    }
                }
            });
        }
    }
}

