/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.BreakException;
import com.intellij.debugger.engine.evaluation.expression.ContinueException;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.openapi.util.Comparing;

public abstract class LoopEvaluator
implements Evaluator {
    private final String myLabelName;
    private final Evaluator myBodyEvaluator;

    public LoopEvaluator(String labelName, Evaluator bodyEvaluator) {
        this.myLabelName = labelName;
        this.myBodyEvaluator = bodyEvaluator != null ? new DisableGC(bodyEvaluator) : null;
    }

    protected boolean body(EvaluationContextImpl context) throws EvaluateException {
        block4: {
            try {
                this.evaluateBody(context);
            }
            catch (BreakException e) {
                if (Comparing.equal((String)e.getLabelName(), (String)this.myLabelName)) {
                    return true;
                }
                throw e;
            }
            catch (ContinueException e) {
                if (Comparing.equal((String)e.getLabelName(), (String)this.myLabelName)) break block4;
                throw e;
            }
        }
        return false;
    }

    public String getLabelName() {
        return this.myLabelName;
    }

    protected void evaluateBody(EvaluationContextImpl context) throws EvaluateException {
        if (this.myBodyEvaluator != null) {
            this.myBodyEvaluator.evaluate(context);
        }
    }
}

