/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.StaticDescriptor;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.sun.jdi.Field;
import com.sun.jdi.ReferenceType;

public class StaticDescriptorImpl
extends NodeDescriptorImpl
implements StaticDescriptor {
    private final ReferenceType myType;
    private final boolean myHasStaticFields;

    public StaticDescriptorImpl(ReferenceType refType) {
        this.myType = refType;
        boolean hasStaticFields = false;
        for (Field field : this.myType.allFields()) {
            if (!field.isStatic()) continue;
            hasStaticFields = true;
            break;
        }
        this.myHasStaticFields = hasStaticFields;
    }

    @Override
    public ReferenceType getType() {
        return this.myType;
    }

    @Override
    public String getName() {
        return "static";
    }

    @Override
    public boolean isExpandable() {
        return this.myHasStaticFields;
    }

    @Override
    public void setContext(EvaluationContextImpl context) {
    }

    @Override
    protected String calcRepresentation(EvaluationContextImpl context, DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
        return this.getName() + " = " + classRenderer.renderTypeName(this.myType.name());
    }
}

