/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.ToStringBasedRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ClassObjectRenderer
extends ToStringBasedRenderer
implements FullValueEvaluatorProvider {
    private static final Logger LOG = Logger.getInstance(ClassObjectRenderer.class);

    public ClassObjectRenderer(NodeRendererSettings rendererSettings) {
        super(rendererSettings, "Class", null, null);
        this.setClassName("java.lang.Class");
        this.setEnabled(true);
    }

    @Override
    @Nullable
    public XFullValueEvaluator getFullValueEvaluator(final EvaluationContextImpl evaluationContext, final ValueDescriptorImpl valueDescriptor) {
        return new JavaValue.JavaFullValueEvaluator(DebuggerBundle.message((String)"message.node.navigate", (Object[])new Object[0]), evaluationContext){

            @Override
            public void evaluate(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                if (callback == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/debugger/ui/tree/render/ClassObjectRenderer$1", "evaluate"));
                }
                Value value = valueDescriptor.getValue();
                ClassType type = (ClassType)value.type();
                Method nameMethod = type.concreteMethodByName("getName", "()Ljava/lang/String;");
                if (nameMethod != null) {
                    try {
                        final DebugProcessImpl process = evaluationContext.getDebugProcess();
                        Value res = process.invokeMethod((EvaluationContext)evaluationContext, (ObjectReference)value, nameMethod, Collections.emptyList());
                        if (res instanceof StringReference) {
                            callback.evaluated("");
                            final String line = ((StringReference)res).value();
                            ApplicationManager.getApplication().runReadAction(new Runnable(){

                                @Override
                                public void run() {
                                    final PsiClass psiClass = DebuggerUtils.findClass((String)line, (Project)valueDescriptor.getProject(), (GlobalSearchScope)process.getSearchScope());
                                    if (psiClass != null) {
                                        DebuggerUIUtil.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                psiClass.navigate(true);
                                            }
                                        });
                                    }
                                }
                            });
                        }
                    }
                    catch (EvaluateException e) {
                        LOG.info("Exception while getting type name", (Throwable)e);
                    }
                }
            }

            public boolean isShowValuePopup() {
                return false;
            }
        };
    }
}

