/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.remote;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RemoteConfigurationType
implements ConfigurationType {
    private final ConfigurationFactory myFactory = new ConfigurationFactory(this){

        public RunConfiguration createTemplateConfiguration(Project project2) {
            return new RemoteConfiguration(project2, this);
        }
    };

    public String getDisplayName() {
        return ExecutionBundle.message((String)"remote.debug.configuration.display.name", (Object[])new Object[0]);
    }

    public String getConfigurationTypeDescription() {
        return ExecutionBundle.message((String)"remote.debug.configuration.description", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return AllIcons.RunConfigurations.Remote;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myFactory};
    }

    @NotNull
    public ConfigurationFactory getFactory() {
        ConfigurationFactory configurationFactory = this.myFactory;
        if (configurationFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/remote/RemoteConfigurationType", "getFactory"));
        }
        return configurationFactory;
    }

    @NotNull
    public String getId() {
        if ("Remote" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/remote/RemoteConfigurationType", "getId"));
        }
        return "Remote";
    }

    @NotNull
    public static RemoteConfigurationType getInstance() {
        RemoteConfigurationType remoteConfigurationType = (RemoteConfigurationType)ConfigurationTypeUtil.findConfigurationType(RemoteConfigurationType.class);
        if (remoteConfigurationType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/remote/RemoteConfigurationType", "getInstance"));
        }
        return remoteConfigurationType;
    }
}

