/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.LayoutAttractionPolicy;
import com.intellij.execution.ui.layout.LayoutStateDefaults;
import com.intellij.execution.ui.layout.LayoutViewOptions;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.execution.ui.layout.impl.RunnerLayout;
import com.intellij.execution.ui.layout.impl.RunnerLayoutSettings;
import com.intellij.execution.ui.layout.impl.ViewImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.ui.switcher.SwitchProvider;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunnerLayoutUiImpl
implements Disposable.Parent,
RunnerLayoutUi,
LayoutStateDefaults,
LayoutViewOptions,
DataProvider {
    private final RunnerLayout myLayout;
    private final RunnerContentUi myContentUI;
    private final ContentManager myViewsContentManager;
    public static final Key<String> CONTENT_TYPE = Key.create((String)"ContentType");

    public RunnerLayoutUiImpl(@NotNull Project project2, @NotNull Disposable parent, @NotNull String runnerId, @NotNull String runnerTitle, @NotNull String sessionName) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "<init>"));
        }
        if (runnerId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnerId", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "<init>"));
        }
        if (runnerTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnerTitle", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "<init>"));
        }
        if (sessionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionName", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "<init>"));
        }
        this.myLayout = RunnerLayoutSettings.getInstance().getLayout(runnerId);
        Disposer.register((Disposable)parent, (Disposable)this);
        this.myContentUI = new RunnerContentUi(project2, this, ActionManager.getInstance(), IdeFocusManager.getInstance((Project)project2), this.myLayout, runnerTitle + " - " + sessionName);
        Disposer.register((Disposable)this, (Disposable)this.myContentUI);
        this.myViewsContentManager = RunnerLayoutUiImpl.getContentFactory().createContentManager(this.myContentUI.getContentUI(), false, project2);
        this.myViewsContentManager.addDataProvider((DataProvider)this);
        Disposer.register((Disposable)this, (Disposable)this.myViewsContentManager);
    }

    @NotNull
    public LayoutViewOptions setTopToolbar(@NotNull ActionGroup actions, @NotNull String place) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "setTopToolbar"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "setTopToolbar"));
        }
        this.myContentUI.setTopActions(actions, place);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "setTopToolbar"));
        }
        return runnerLayoutUiImpl;
    }

    @NotNull
    public LayoutStateDefaults initTabDefaults(int id, String text, Icon icon) {
        this.getLayout().setDefault(id, text, icon);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "initTabDefaults"));
        }
        return runnerLayoutUiImpl;
    }

    @NotNull
    public LayoutStateDefaults initFocusContent(@NotNull String id, @NotNull String condition) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "initFocusContent"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "initFocusContent"));
        }
        LayoutStateDefaults layoutStateDefaults = this.initFocusContent(id, condition, (LayoutAttractionPolicy)new LayoutAttractionPolicy.FocusOnce());
        if (layoutStateDefaults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "initFocusContent"));
        }
        return layoutStateDefaults;
    }

    @NotNull
    public LayoutStateDefaults initFocusContent(@NotNull String id, @NotNull String condition, @NotNull LayoutAttractionPolicy policy) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "initFocusContent"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "initFocusContent"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "initFocusContent"));
        }
        this.getLayout().setDefaultToFocus(id, condition, policy);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "initFocusContent"));
        }
        return runnerLayoutUiImpl;
    }

    @NotNull
    public Content addContent(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "addContent"));
        }
        Content content2 = this.addContent(content, false, -1, PlaceInGrid.center, false);
        if (content2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "addContent"));
        }
        return content2;
    }

    @NotNull
    public Content addContent(@NotNull Content content, int defaultTabId, @NotNull PlaceInGrid defaultPlace, boolean defaultIsMinimized) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "addContent"));
        }
        if (defaultPlace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultPlace", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "addContent"));
        }
        Content content2 = this.addContent(content, true, defaultTabId, defaultPlace, defaultIsMinimized);
        if (content2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "addContent"));
        }
        return content2;
    }

    public Content addContent(@NotNull Content content, boolean applyDefaults, int defaultTabId, @NotNull PlaceInGrid defaultPlace, boolean defaultIsMinimized) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "addContent"));
        }
        if (defaultPlace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultPlace", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "addContent"));
        }
        String id = (String)content.getUserData(CONTENT_TYPE);
        assert (id != null) : "Content id is missing, use RunnerLayoutUi to create content instances";
        if (applyDefaults) {
            this.getLayout().setDefault(id, defaultTabId, defaultPlace, defaultIsMinimized);
        }
        this.getContentManager().addContent(content);
        return content;
    }

    @NotNull
    public Content createContent(@NotNull String id, @NotNull JComponent component, @NotNull String displayName, @Nullable Icon icon, @Nullable JComponent focusable) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "createContent"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "createContent"));
        }
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "createContent"));
        }
        Content content = this.createContent(id, (ComponentWithActions)new ComponentWithActions.Impl(component), displayName, icon, focusable);
        if (content == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "createContent"));
        }
        return content;
    }

    @NotNull
    public Content createContent(@NotNull String contentId, @NotNull ComponentWithActions withActions, @NotNull String displayName, @Nullable Icon icon, @Nullable JComponent toFocus) {
        if (contentId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentId", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "createContent"));
        }
        if (withActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "withActions", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "createContent"));
        }
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "createContent"));
        }
        Content content = RunnerLayoutUiImpl.getContentFactory().createContent(withActions.getComponent(), displayName, false);
        content.putUserData(CONTENT_TYPE, (Object)contentId);
        content.putUserData(ViewImpl.ID, (Object)contentId);
        content.setIcon(icon);
        if (toFocus != null) {
            content.setPreferredFocusableComponent(toFocus);
        }
        if (!withActions.isContentBuiltIn()) {
            content.setSearchComponent(withActions.getSearchComponent());
            content.setActions(withActions.getToolbarActions(), withActions.getToolbarPlace(), withActions.getToolbarContextComponent());
        }
        Content content2 = content;
        if (content2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "createContent"));
        }
        return content2;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myViewsContentManager.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "getComponent"));
        }
        return jComponent;
    }

    private static ContentFactory getContentFactory() {
        return ContentFactory.SERVICE.getInstance();
    }

    public RunnerLayout getLayout() {
        return this.myLayout;
    }

    public void updateActionsNow() {
        this.myContentUI.updateActionsImmediately();
    }

    public void beforeTreeDispose() {
        this.myContentUI.saveUiState();
    }

    public void dispose() {
    }

    @NotNull
    public ContentManager getContentManager() {
        ContentManager contentManager = this.myViewsContentManager;
        if (contentManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "getContentManager"));
        }
        return contentManager;
    }

    @NotNull
    public ActionCallback selectAndFocus(@Nullable Content content, boolean requestFocus, boolean forced) {
        ActionCallback actionCallback = this.selectAndFocus(content, requestFocus, forced, false);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "selectAndFocus"));
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback selectAndFocus(@Nullable Content content, boolean requestFocus, boolean forced, boolean implicit) {
        if (content == null) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "selectAndFocus"));
            }
            return actionCallback;
        }
        ActionCallback actionCallback = this.getContentManager(content).setSelectedContent(content, requestFocus || this.shouldRequestFocus(), forced, implicit);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "selectAndFocus"));
        }
        return actionCallback;
    }

    private ContentManager getContentManager(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "getContentManager"));
        }
        return this.myContentUI.getContentManager(content);
    }

    private boolean shouldRequestFocus() {
        Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return focused != null && SwingUtilities.isDescendingFrom(focused, this.getContentManager().getComponent());
    }

    public boolean removeContent(@Nullable Content content, boolean dispose) {
        return content != null && this.getContentManager().removeContent(content, dispose);
    }

    public boolean isToFocus(@NotNull Content content, @NotNull String condition) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "isToFocus"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "isToFocus"));
        }
        String id = (String)content.getUserData(ViewImpl.ID);
        return this.getLayout().isToFocus(id, condition);
    }

    @NotNull
    public LayoutViewOptions setToFocus(@Nullable Content content, @NotNull String condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "setToFocus"));
        }
        this.getLayout().setToFocus(content != null ? (String)content.getUserData(ViewImpl.ID) : null, condition);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "setToFocus"));
        }
        return runnerLayoutUiImpl;
    }

    public void attractBy(@NotNull String condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "attractBy"));
        }
        this.myContentUI.attractByCondition(condition, true);
    }

    public void clearAttractionBy(@NotNull String condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "clearAttractionBy"));
        }
        this.myContentUI.clearAttractionByCondition(condition, true);
    }

    public void removeContent(@NotNull String id, boolean dispose) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "removeContent"));
        }
        Content content = this.findContent(id);
        if (content != null) {
            this.getContentManager().removeContent(content, dispose);
        }
    }

    public AnAction getLayoutActions() {
        return this.myContentUI.getLayoutActions();
    }

    @NotNull
    public AnAction[] getLayoutActionsList() {
        ActionGroup group = (ActionGroup)this.getLayoutActions();
        AnAction[] anActionArray = group.getChildren(null);
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "getLayoutActionsList"));
        }
        return anActionArray;
    }

    @NotNull
    public LayoutViewOptions setTabPopupActions(@NotNull ActionGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "setTabPopupActions"));
        }
        this.myContentUI.setTabPopupActions(group);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "setTabPopupActions"));
        }
        return runnerLayoutUiImpl;
    }

    @NotNull
    public LayoutViewOptions setLeftToolbar(@NotNull ActionGroup leftToolbar, @NotNull String place) {
        if (leftToolbar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftToolbar", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "setLeftToolbar"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "setLeftToolbar"));
        }
        this.myContentUI.setLeftToolbar(leftToolbar, place);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "setLeftToolbar"));
        }
        return runnerLayoutUiImpl;
    }

    @Nullable
    public Content findContent(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "findContent"));
        }
        return this.myContentUI.findContent(key);
    }

    @NotNull
    public RunnerLayoutUi addListener(final @NotNull ContentManagerListener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "addListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "addListener"));
        }
        final ContentManager mgr = this.getContentManager();
        mgr.addContentManagerListener(listener2);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                mgr.removeContentManagerListener(listener2);
            }
        });
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "addListener"));
        }
        return runnerLayoutUiImpl;
    }

    public void removeListener(@NotNull ContentManagerListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "removeListener"));
        }
        this.getContentManager().removeContentManagerListener(listener2);
    }

    public void setBouncing(@NotNull Content content, boolean activate) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "setBouncing"));
        }
        this.myContentUI.processBounce(content, activate);
    }

    public boolean isDisposed() {
        return this.getContentManager().isDisposed();
    }

    @NotNull
    public LayoutViewOptions setMinimizeActionEnabled(boolean enabled) {
        this.myContentUI.setMinimizeActionEnabled(enabled);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "setMinimizeActionEnabled"));
        }
        return runnerLayoutUiImpl;
    }

    public LayoutViewOptions setToDisposeRemoveContent(boolean toDispose) {
        this.myContentUI.setToDisposeRemovedContent(toDispose);
        return this;
    }

    @NotNull
    public LayoutViewOptions setMoveToGridActionEnabled(boolean enabled) {
        this.myContentUI.setMovetoGridActionEnabled(enabled);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "setMoveToGridActionEnabled"));
        }
        return runnerLayoutUiImpl;
    }

    @NotNull
    public LayoutViewOptions setAttractionPolicy(@NotNull String contentId, LayoutAttractionPolicy policy) {
        if (contentId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentId", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "setAttractionPolicy"));
        }
        this.myContentUI.setPolicy(contentId, policy);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "setAttractionPolicy"));
        }
        return runnerLayoutUiImpl;
    }

    @NotNull
    public LayoutViewOptions setConditionAttractionPolicy(@NotNull String condition, LayoutAttractionPolicy policy) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "setConditionAttractionPolicy"));
        }
        this.myContentUI.setConditionPolicy(condition, policy);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "setConditionAttractionPolicy"));
        }
        return runnerLayoutUiImpl;
    }

    @NotNull
    public LayoutStateDefaults getDefaults() {
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "getDefaults"));
        }
        return runnerLayoutUiImpl;
    }

    @NotNull
    public LayoutViewOptions getOptions() {
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "getOptions"));
        }
        return runnerLayoutUiImpl;
    }

    @NotNull
    public LayoutViewOptions setAdditionalFocusActions(@NotNull ActionGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "setAdditionalFocusActions"));
        }
        this.myContentUI.setAdditionalFocusActions(group);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "setAdditionalFocusActions"));
        }
        return runnerLayoutUiImpl;
    }

    public AnAction getSettingsActions() {
        return this.myContentUI.getSettingsActions();
    }

    @NotNull
    public AnAction[] getSettingsActionsList() {
        ActionGroup group = (ActionGroup)this.getSettingsActions();
        AnAction[] anActionArray = group.getChildren(null);
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "getSettingsActionsList"));
        }
        return anActionArray;
    }

    @NotNull
    public Content[] getContents() {
        Content[] contents = new Content[this.getContentManager().getContentCount()];
        for (int i = 0; i < contents.length; ++i) {
            contents[i] = this.getContentManager().getContent(i);
        }
        if (contents == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl", "getContents"));
        }
        return contents;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (SwitchProvider.KEY.is(dataId) || QuickActionProvider.KEY.is(dataId) || RunnerContentUi.KEY.is(dataId)) {
            return this.myContentUI;
        }
        return null;
    }
}

