/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.find.EditorSearchSession;
import com.intellij.find.editorHeaderActions.OccurrenceAction;
import com.intellij.find.editorHeaderActions.Utils;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class SelectAllAction
extends OccurrenceAction {
    public SelectAllAction() {
        super("SelectAllOccurrences", AllIcons.Actions.CheckMulticaret);
    }

    public void actionPerformed(AnActionEvent e) {
        EditorSearchSession search = (EditorSearchSession)e.getRequiredData(EditorSearchSession.SESSION_KEY);
        search.selectAllOccurrences();
        search.close();
    }

    @Override
    @Nullable
    public ShortcutSet getShortcut() {
        ArrayList shortcuts = ContainerUtil.newArrayList();
        AnAction selectAllOccurrences = ActionManager.getInstance().getAction("SelectAllOccurrences");
        if (selectAllOccurrences != null) {
            ContainerUtil.addAll((Collection)shortcuts, (Object[])selectAllOccurrences.getShortcutSet().getShortcuts());
        }
        ContainerUtil.addAll((Collection)shortcuts, (Object[])CommonShortcuts.ALT_ENTER.getShortcuts());
        return Utils.shortcutSetOf(shortcuts);
    }
}

