/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl.livePreview;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.impl.livePreview.ReplacementView;
import com.intellij.find.impl.livePreview.SearchResults;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.PositionTracker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LivePreview
extends DocumentAdapter
implements SearchResults.SearchResultsListener,
SelectionListener {
    private static final Key<Object> IN_SELECTION_KEY = Key.create((String)"LivePreview.IN_SELECTION_KEY");
    private static final Object IN_SELECTION1 = new Object();
    private static final Object IN_SELECTION2 = new Object();
    private static final String EMPTY_STRING_DISPLAY_TEXT = "<Empty string>";
    private boolean myListeningSelection = false;
    private boolean mySuppressedUpdate = false;
    private boolean myInSmartUpdate = false;
    private static final Key<Object> MARKER_USED = Key.create((String)"LivePreview.MARKER_USED");
    private static final Object YES = new Object();
    private static final Key<Object> SEARCH_MARKER = Key.create((String)"LivePreview.SEARCH_MARKER");
    public static PrintStream ourTestOutput;
    private String myReplacementPreviewText;
    private static boolean NotFound;
    private final Set<RangeHighlighter> myHighlighters = new HashSet<RangeHighlighter>();
    private RangeHighlighter myCursorHighlighter;
    private final List<VisibleAreaListener> myVisibleAreaListenersToRemove = new ArrayList<VisibleAreaListener>();
    private Delegate myDelegate;
    private final SearchResults mySearchResults;
    private Balloon myReplacementBalloon;

    public void selectionChanged(SelectionEvent e) {
        this.updateInSelectionHighlighters();
    }

    public void inSmartUpdate() {
        this.myInSmartUpdate = true;
    }

    public static void processNotFound() {
        NotFound = true;
    }

    private static TextAttributes strikeout() {
        Color color = EditorColorsManager.getInstance().getGlobalScheme().getDefaultForeground();
        return new TextAttributes(null, null, color, EffectType.STRIKEOUT, 0);
    }

    @Override
    public void searchResultsUpdated(SearchResults sr) {
        Project project2 = this.mySearchResults.getProject();
        if (project2 == null || project2.isDisposed()) {
            return;
        }
        if (this.mySuppressedUpdate) {
            this.mySuppressedUpdate = false;
            return;
        }
        if (!this.myInSmartUpdate) {
            this.removeFromEditor();
        }
        this.highlightUsages();
        this.updateCursorHighlighting();
        if (this.myInSmartUpdate) {
            this.clearUnusedHightlighters();
            this.myInSmartUpdate = false;
        }
    }

    private void dumpState() {
        if (ApplicationManager.getApplication().isUnitTestMode() && ourTestOutput != null) {
            this.dumpEditorMarkupAndSelection(ourTestOutput);
        }
    }

    private void dumpEditorMarkupAndSelection(PrintStream dumpStream) {
        dumpStream.println(this.mySearchResults.getFindModel());
        if (this.myReplacementPreviewText != null) {
            dumpStream.println("--");
            dumpStream.println("Replacement Preview: " + this.myReplacementPreviewText);
        }
        dumpStream.println("--");
        Editor editor = this.mySearchResults.getEditor();
        RangeHighlighter[] highlighters = editor.getMarkupModel().getAllHighlighters();
        ArrayList<Pair> ranges = new ArrayList<Pair>();
        for (RangeHighlighter highlighter : highlighters) {
            ranges.add(new Pair((Object)highlighter.getStartOffset(), (Object)Character.valueOf('[')));
            ranges.add(new Pair((Object)highlighter.getEndOffset(), (Object)Character.valueOf(']')));
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.getSelectionStart() != selectionModel.getSelectionEnd()) {
            ranges.add(new Pair((Object)selectionModel.getSelectionStart(), (Object)Character.valueOf('<')));
            ranges.add(new Pair((Object)selectionModel.getSelectionEnd(), (Object)Character.valueOf('>')));
        }
        ranges.add(new Pair((Object)-1, (Object)Character.valueOf('\n')));
        ranges.add(new Pair((Object)(editor.getDocument().getTextLength() + 1), (Object)Character.valueOf('\n')));
        ContainerUtil.sort(ranges, (Comparator)new Comparator<Pair<Integer, Character>>(){

            @Override
            public int compare(@NotNull Pair<Integer, Character> pair, @NotNull Pair<Integer, Character> pair2) {
                if (pair == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pair", "com/intellij/find/impl/livePreview/LivePreview$1", "compare"));
                }
                if (pair2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pair2", "com/intellij/find/impl/livePreview/LivePreview$1", "compare"));
                }
                int res = (Integer)pair.first - (Integer)pair2.first;
                if (res == 0) {
                    Character c1 = (Character)pair.second;
                    Character c2 = (Character)pair2.second;
                    if (c1.charValue() == '<' && c2.charValue() == '[') {
                        return 1;
                    }
                    if (c1.charValue() == '[' && c2.charValue() == '<') {
                        return -1;
                    }
                    return c1.compareTo(c2);
                }
                return res;
            }
        });
        Document document = editor.getDocument();
        for (int i = 0; i < ranges.size() - 1; ++i) {
            Pair pair = (Pair)ranges.get(i);
            Pair pair1 = (Pair)ranges.get(i + 1);
            dumpStream.print(pair.second + document.getText(TextRange.create((int)Math.max((Integer)pair.first, 0), (int)Math.min((Integer)pair1.first, document.getTextLength()))));
        }
        dumpStream.println("\n--");
        if (NotFound) {
            dumpStream.println("Not Found");
            dumpStream.println("--");
            NotFound = false;
        }
        for (RangeHighlighter highlighter : highlighters) {
            dumpStream.println(highlighter + " : " + highlighter.getTextAttributes());
        }
        dumpStream.println("------------");
    }

    private void clearUnusedHightlighters() {
        com.intellij.util.containers.HashSet unused = new com.intellij.util.containers.HashSet();
        for (RangeHighlighter highlighter : this.myHighlighters) {
            if (highlighter.getUserData(MARKER_USED) == null) {
                unused.add(highlighter);
                continue;
            }
            highlighter.putUserData(MARKER_USED, null);
        }
        this.myHighlighters.removeAll((Collection<?>)unused);
        Project project2 = this.mySearchResults.getProject();
        if (project2 != null && !project2.isDisposed()) {
            for (RangeHighlighter highlighter : unused) {
                HighlightManager.getInstance((Project)project2).removeSegmentHighlighter(this.mySearchResults.getEditor(), highlighter);
            }
        }
    }

    @Override
    public void cursorMoved() {
        this.updateInSelectionHighlighters();
        this.updateCursorHighlighting();
    }

    @Override
    public void updateFinished() {
        this.dumpState();
    }

    private void updateCursorHighlighting() {
        this.hideBalloon();
        if (this.myCursorHighlighter != null) {
            HighlightManager.getInstance((Project)this.mySearchResults.getProject()).removeSegmentHighlighter(this.mySearchResults.getEditor(), this.myCursorHighlighter);
            this.myCursorHighlighter = null;
        }
        FindResult cursor = this.mySearchResults.getCursor();
        Editor editor = this.mySearchResults.getEditor();
        if (cursor != null && cursor.getEndOffset() <= editor.getDocument().getTextLength()) {
            HashSet<RangeHighlighter> dummy = new HashSet<RangeHighlighter>();
            Color color = editor.getColorsScheme().getColor(EditorColors.CARET_COLOR);
            this.highlightRange((TextRange)cursor, new TextAttributes(null, null, color, EffectType.ROUNDED_BOX, 0), dummy);
            if (!dummy.isEmpty()) {
                this.myCursorHighlighter = (RangeHighlighter)dummy.iterator().next();
            }
            editor.getScrollingModel().runActionOnScrollingFinished(new Runnable(){

                @Override
                public void run() {
                    LivePreview.this.showReplacementPreview();
                }
            });
        }
    }

    public LivePreview(SearchResults searchResults) {
        this.mySearchResults = searchResults;
        this.searchResultsUpdated(searchResults);
        searchResults.addListener(this);
        this.myListeningSelection = true;
        this.mySearchResults.getEditor().getSelectionModel().addSelectionListener((SelectionListener)this);
    }

    public Delegate getDelegate() {
        return this.myDelegate;
    }

    public void setDelegate(Delegate delegate) {
        this.myDelegate = delegate;
    }

    public void cleanUp() {
        this.removeFromEditor();
    }

    public void dispose() {
        this.cleanUp();
        this.mySearchResults.removeListener(this);
    }

    private void removeFromEditor() {
        Editor editor = this.mySearchResults.getEditor();
        if (this.myReplacementBalloon != null) {
            this.myReplacementBalloon.hide();
        }
        if (editor != null) {
            for (VisibleAreaListener visibleAreaListener : this.myVisibleAreaListenersToRemove) {
                editor.getScrollingModel().removeVisibleAreaListener(visibleAreaListener);
            }
            this.myVisibleAreaListenersToRemove.clear();
            Project project2 = this.mySearchResults.getProject();
            if (project2 != null && !project2.isDisposed()) {
                for (RangeHighlighter h : this.myHighlighters) {
                    HighlightManager.getInstance((Project)project2).removeSegmentHighlighter(editor, h);
                }
                if (this.myCursorHighlighter != null) {
                    HighlightManager.getInstance((Project)project2).removeSegmentHighlighter(editor, this.myCursorHighlighter);
                    this.myCursorHighlighter = null;
                }
            }
            this.myHighlighters.clear();
            if (this.myListeningSelection) {
                editor.getSelectionModel().removeSelectionListener((SelectionListener)this);
                this.myListeningSelection = false;
            }
        }
    }

    private void highlightUsages() {
        if (this.mySearchResults.getEditor() == null) {
            return;
        }
        if (this.mySearchResults.getMatchesCount() >= this.mySearchResults.getMatchesLimit()) {
            return;
        }
        for (FindResult range : this.mySearchResults.getOccurrences()) {
            if (range.getEndOffset() > this.mySearchResults.getEditor().getDocument().getTextLength()) continue;
            TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES);
            if (range.getLength() == 0) {
                attributes = attributes.clone();
                attributes.setEffectType(EffectType.BOXED);
                attributes.setEffectColor(attributes.getBackgroundColor());
            }
            if (this.mySearchResults.isExcluded(range)) {
                this.highlightRange((TextRange)range, LivePreview.strikeout(), this.myHighlighters);
                continue;
            }
            this.highlightRange((TextRange)range, attributes, this.myHighlighters);
        }
        this.updateInSelectionHighlighters();
        if (!this.myListeningSelection) {
            this.mySearchResults.getEditor().getSelectionModel().addSelectionListener((SelectionListener)this);
            this.myListeningSelection = true;
        }
    }

    private void updateInSelectionHighlighters() {
        if (this.mySearchResults.getEditor() == null) {
            return;
        }
        SelectionModel selectionModel = this.mySearchResults.getEditor().getSelectionModel();
        int[] starts = selectionModel.getBlockSelectionStarts();
        int[] ends = selectionModel.getBlockSelectionEnds();
        HashSet<RangeHighlighter> toRemove = new HashSet<RangeHighlighter>();
        HashSet<RangeHighlighter> toAdd = new HashSet<RangeHighlighter>();
        for (RangeHighlighter highlighter : this.myHighlighters) {
            FindResult cursor;
            Object userData;
            if (!highlighter.isValid()) continue;
            boolean intersectsWithSelection = false;
            for (int i = 0; i < starts.length; ++i) {
                TextRange selectionRange = new TextRange(starts[i], ends[i]);
                boolean bl = intersectsWithSelection = selectionRange.intersects(highlighter.getStartOffset(), highlighter.getEndOffset()) && selectionRange.getEndOffset() != highlighter.getStartOffset() && highlighter.getEndOffset() != selectionRange.getStartOffset();
                if (intersectsWithSelection) break;
            }
            if ((userData = highlighter.getUserData(IN_SELECTION_KEY)) != null) {
                if (intersectsWithSelection) continue;
                if (userData == IN_SELECTION2) {
                    HighlightManager.getInstance((Project)this.mySearchResults.getProject()).removeSegmentHighlighter(this.mySearchResults.getEditor(), highlighter);
                    toRemove.add(highlighter);
                    continue;
                }
                highlighter.putUserData(IN_SELECTION_KEY, null);
                continue;
            }
            if (!intersectsWithSelection || (cursor = this.mySearchResults.getCursor()) != null && highlighter.getStartOffset() == cursor.getStartOffset() && highlighter.getEndOffset() == cursor.getEndOffset()) continue;
            RangeHighlighter toAnnotate = this.highlightRange(new TextRange(highlighter.getStartOffset(), highlighter.getEndOffset()), new TextAttributes(null, null, Color.WHITE, EffectType.ROUNDED_BOX, 0), toAdd);
            highlighter.putUserData(IN_SELECTION_KEY, IN_SELECTION1);
            toAnnotate.putUserData(IN_SELECTION_KEY, IN_SELECTION2);
        }
        this.myHighlighters.removeAll(toRemove);
        this.myHighlighters.addAll(toAdd);
    }

    private void showReplacementPreview() {
        this.hideBalloon();
        if (!this.mySearchResults.isUpToDate()) {
            return;
        }
        FindResult cursor = this.mySearchResults.getCursor();
        Editor editor = this.mySearchResults.getEditor();
        if (this.myDelegate != null && cursor != null) {
            FindModel findModel;
            String replacementPreviewText = this.myDelegate.getStringToReplace(editor, cursor);
            if (StringUtil.isEmpty((String)replacementPreviewText)) {
                replacementPreviewText = EMPTY_STRING_DISPLAY_TEXT;
            }
            if ((findModel = this.mySearchResults.getFindModel()).isRegularExpressions() && findModel.isReplaceState()) {
                this.showBalloon(editor, replacementPreviewText);
            }
        }
    }

    private void showBalloon(Editor editor, String replacementPreviewText) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myReplacementPreviewText = replacementPreviewText;
            return;
        }
        ReplacementView replacementView = new ReplacementView(replacementPreviewText);
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)replacementView);
        balloonBuilder.setFadeoutTime(0L);
        balloonBuilder.setFillColor(IdeTooltipManager.GRAPHITE_COLOR);
        balloonBuilder.setAnimationCycle(0);
        balloonBuilder.setHideOnClickOutside(false);
        balloonBuilder.setHideOnKeyOutside(false);
        balloonBuilder.setHideOnAction(false);
        balloonBuilder.setCloseButtonEnabled(true);
        this.myReplacementBalloon = balloonBuilder.createBalloon();
        this.myReplacementBalloon.show((PositionTracker)new ReplacementBalloonPositionTracker(editor), Balloon.Position.below);
    }

    private void hideBalloon() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myReplacementPreviewText = null;
            return;
        }
        if (this.myReplacementBalloon != null) {
            this.myReplacementBalloon.hide();
            this.myReplacementBalloon = null;
        }
    }

    @NotNull
    private RangeHighlighter highlightRange(TextRange textRange, TextAttributes attributes, Set<RangeHighlighter> highlighters) {
        if (this.myInSmartUpdate) {
            for (RangeHighlighter highlighter : this.myHighlighters) {
                if (!highlighter.isValid() || highlighter.getStartOffset() != textRange.getStartOffset() || highlighter.getEndOffset() != textRange.getEndOffset() || !attributes.equals((Object)highlighter.getTextAttributes())) continue;
                highlighter.putUserData(MARKER_USED, YES);
                if (highlighters != this.myHighlighters) {
                    highlighters.add(highlighter);
                }
                RangeHighlighter rangeHighlighter = highlighter;
                if (rangeHighlighter == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/livePreview/LivePreview", "highlightRange"));
                }
                return rangeHighlighter;
            }
        }
        RangeHighlighter highlighter = this.doHightlightRange(textRange, attributes, highlighters);
        if (this.myInSmartUpdate) {
            highlighter.putUserData(MARKER_USED, YES);
        }
        RangeHighlighter rangeHighlighter = highlighter;
        if (rangeHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/livePreview/LivePreview", "highlightRange"));
        }
        return rangeHighlighter;
    }

    private RangeHighlighter doHightlightRange(final TextRange textRange, final TextAttributes attributes, Set<RangeHighlighter> highlighters) {
        HighlightManager highlightManager = HighlightManager.getInstance((Project)this.mySearchResults.getProject());
        MarkupModelEx markupModel = (MarkupModelEx)this.mySearchResults.getEditor().getMarkupModel();
        final RangeHighlighter[] candidate = new RangeHighlighter[1];
        boolean notFound = markupModel.processRangeHighlightersOverlappingWith(textRange.getStartOffset(), textRange.getEndOffset(), (Processor<? super RangeHighlighterEx>)new Processor<RangeHighlighterEx>(){

            public boolean process(RangeHighlighterEx highlighter) {
                TextAttributes textAttributes = highlighter.getTextAttributes();
                if (highlighter.getUserData(SEARCH_MARKER) != null && textAttributes != null && textAttributes.equals((Object)attributes) && highlighter.getStartOffset() == textRange.getStartOffset() && highlighter.getEndOffset() == textRange.getEndOffset()) {
                    candidate[0] = highlighter;
                    return false;
                }
                return true;
            }
        });
        if (!notFound && highlighters.contains(candidate[0])) {
            return candidate[0];
        }
        ArrayList dummy = new ArrayList();
        highlightManager.addRangeHighlight(this.mySearchResults.getEditor(), textRange.getStartOffset(), textRange.getEndOffset(), attributes, false, dummy);
        RangeHighlighter h = (RangeHighlighter)dummy.get(0);
        highlighters.add(h);
        h.putUserData(SEARCH_MARKER, YES);
        return h;
    }

    private static void requestBalloonHiding(final Balloon object) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                object.hide();
            }
        });
    }

    private class ReplacementBalloonPositionTracker
    extends PositionTracker<Balloon> {
        private final Editor myEditor;

        public ReplacementBalloonPositionTracker(Editor editor) {
            super((Component)editor.getContentComponent());
            this.myEditor = editor;
        }

        public RelativePoint recalculateLocation(Balloon object) {
            FindResult cursor = LivePreview.this.mySearchResults.getCursor();
            if (cursor == null) {
                return null;
            }
            FindResult cur = cursor;
            int startOffset = cur.getStartOffset();
            int endOffset = cur.getEndOffset();
            if (endOffset > this.myEditor.getDocument().getTextLength()) {
                if (!object.isDisposed()) {
                    LivePreview.requestBalloonHiding(object);
                }
                return null;
            }
            if (!SearchResults.insideVisibleArea(this.myEditor, (TextRange)cur)) {
                LivePreview.requestBalloonHiding(object);
                VisibleAreaListener visibleAreaListener = new VisibleAreaListener((TextRange)cur){
                    final /* synthetic */ TextRange val$cur;
                    {
                        this.val$cur = textRange;
                    }

                    public void visibleAreaChanged(VisibleAreaEvent e) {
                        if (SearchResults.insideVisibleArea(ReplacementBalloonPositionTracker.this.myEditor, this.val$cur)) {
                            LivePreview.this.showReplacementPreview();
                            1 visibleAreaListener = this;
                            boolean remove = LivePreview.this.myVisibleAreaListenersToRemove.remove(visibleAreaListener);
                            if (remove) {
                                ReplacementBalloonPositionTracker.this.myEditor.getScrollingModel().removeVisibleAreaListener((VisibleAreaListener)visibleAreaListener);
                            }
                        }
                    }
                };
                this.myEditor.getScrollingModel().addVisibleAreaListener(visibleAreaListener);
                LivePreview.this.myVisibleAreaListenersToRemove.add(visibleAreaListener);
            }
            Point startPoint = this.myEditor.visualPositionToXY(this.myEditor.offsetToVisualPosition(startOffset));
            Point endPoint = this.myEditor.visualPositionToXY(this.myEditor.offsetToVisualPosition(endOffset));
            Point point = new Point((startPoint.x + endPoint.x) / 2, startPoint.y + this.myEditor.getLineHeight());
            return new RelativePoint((Component)this.myEditor.getContentComponent(), point);
        }
    }

    public static interface Delegate {
        @Nullable
        public String getStringToReplace(@NotNull Editor var1, @Nullable FindResult var2);
    }
}

