/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;

public class PowerSaveMode {
    private static final String POWER_SAVE_MODE = "power.save.mode";
    private boolean myEnabled = PropertiesComponent.getInstance().getBoolean("power.save.mode");
    private final MessageBus myBus;
    public static Topic<Listener> TOPIC = Topic.create((String)"PowerSaveMode.Listener", Listener.class);

    public PowerSaveMode(MessageBus bus) {
        this.myBus = bus;
    }

    public static boolean isEnabled() {
        return ((PowerSaveMode)ServiceManager.getService(PowerSaveMode.class)).myEnabled;
    }

    public static void setEnabled(boolean value) {
        PowerSaveMode instance = (PowerSaveMode)ServiceManager.getService(PowerSaveMode.class);
        if (instance.myEnabled != value) {
            instance.myEnabled = value;
            ((Listener)instance.myBus.syncPublisher(TOPIC)).powerSaveStateChanged();
            PropertiesComponent.getInstance().setValue(POWER_SAVE_MODE, value);
        }
    }

    public static interface Listener {
        public void powerSaveStateChanged();
    }
}

