/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HideToolWindowAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project2 == null) {
            return;
        }
        ToolWindowManagerEx toolWindowManager = ToolWindowManagerEx.getInstanceEx(project2);
        String id = toolWindowManager.getActiveToolWindowId();
        if (id == null) {
            id = toolWindowManager.getLastActiveToolWindowId();
        }
        if (HideToolWindowAction.shouldBeHiddenByShortCut(toolWindowManager, id)) {
            toolWindowManager.getToolWindow(id).hide(null);
        }
    }

    static boolean shouldBeHiddenByShortCut(@NotNull ToolWindowManagerEx manager, @Nullable String id) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/ide/actions/HideToolWindowAction", "shouldBeHiddenByShortCut"));
        }
        if (id == null) {
            return false;
        }
        ToolWindow window = manager.getToolWindow(id);
        return window.isVisible() && window.getType() != ToolWindowType.WINDOWED;
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(event.getDataContext());
        if (project2 == null) {
            presentation.setEnabled(false);
            return;
        }
        ToolWindowManagerEx toolWindowManager = ToolWindowManagerEx.getInstanceEx(project2);
        String id = toolWindowManager.getActiveToolWindowId();
        if (id == null) {
            id = toolWindowManager.getLastActiveToolWindowId();
        }
        presentation.setEnabled(HideToolWindowAction.shouldBeHiddenByShortCut(toolWindowManager, id));
    }
}

