/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.CommonBundle;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NavigatableWithText;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFileNode
extends BasePsiNode<PsiFile>
implements NavigatableWithText {
    public PsiFileNode(Project project2, PsiFile value, ViewSettings viewSettings) {
        super(project2, value, viewSettings);
    }

    @Override
    public Collection<AbstractTreeNode> getChildrenImpl() {
        PsiDirectory psiDirectory;
        Project project2 = this.getProject();
        VirtualFile jarRoot = this.getJarRoot();
        if (project2 != null && jarRoot != null && (psiDirectory = PsiManager.getInstance((Project)project2).findDirectory(jarRoot)) != null) {
            return ProjectViewDirectoryHelper.getInstance(project2).getDirectoryChildren(psiDirectory, this.getSettings(), true);
        }
        return new ArrayList<AbstractTreeNode>();
    }

    private boolean isArchive() {
        VirtualFile file2 = this.getVirtualFile();
        return file2 != null && file2.isValid() && file2.getFileType() instanceof ArchiveFileType;
    }

    @Override
    protected void updateImpl(PresentationData data) {
        PsiFile value = (PsiFile)this.getValue();
        data.setPresentableText(value.getName());
        data.setIcon(value.getIcon(2));
        VirtualFile file2 = this.getVirtualFile();
        if (file2 != null && file2.is(VFileProperty.SYMLINK)) {
            String target = file2.getCanonicalPath();
            if (target == null) {
                data.setAttributesKey(CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES);
                data.setTooltip(CommonBundle.message((String)"vfs.broken.link", (Object[])new Object[0]));
            } else {
                data.setTooltip(FileUtil.toSystemDependentName((String)target));
            }
        }
    }

    public VirtualFile getVirtualFile() {
        PsiFile value = (PsiFile)this.getValue();
        return value != null ? value.getVirtualFile() : null;
    }

    @Override
    public boolean canNavigate() {
        return this.isNavigatableLibraryRoot() || super.canNavigate();
    }

    private boolean isNavigatableLibraryRoot() {
        VirtualFile jarRoot = this.getJarRoot();
        Project project2 = this.getProject();
        if (jarRoot != null && ProjectRootsUtil.isLibraryRoot(jarRoot, project2)) {
            OrderEntry orderEntry = LibraryUtil.findLibraryEntry((VirtualFile)jarRoot, (Project)project2);
            return orderEntry != null && ProjectSettingsService.getInstance(project2).canOpenLibraryOrSdkSettings(orderEntry);
        }
        return false;
    }

    @Nullable
    private VirtualFile getJarRoot() {
        VirtualFile file2 = this.getVirtualFile();
        if (file2 == null || !file2.isValid() || !(file2.getFileType() instanceof ArchiveFileType)) {
            return null;
        }
        return JarFileSystem.getInstance().getJarRootForLocalFile(file2);
    }

    @Override
    public void navigate(boolean requestFocus) {
        OrderEntry orderEntry;
        VirtualFile jarRoot = this.getJarRoot();
        Project project2 = this.getProject();
        if (requestFocus && jarRoot != null && ProjectRootsUtil.isLibraryRoot(jarRoot, project2) && (orderEntry = LibraryUtil.findLibraryEntry((VirtualFile)jarRoot, (Project)project2)) != null) {
            ProjectSettingsService.getInstance(project2).openLibraryOrSdkSettings(orderEntry);
            return;
        }
        super.navigate(requestFocus);
    }

    public String getNavigateActionText(boolean focusEditor) {
        return this.isNavigatableLibraryRoot() ? ActionsBundle.message((String)"action.LibrarySettings.navigate", (Object[])new Object[0]) : null;
    }

    public int getWeight() {
        return 20;
    }

    public String getTitle() {
        VirtualFile file2 = this.getVirtualFile();
        if (file2 != null) {
            return FileUtil.getLocationRelativeToUserHome((String)file2.getPresentableUrl());
        }
        return super.getTitle();
    }

    @Override
    protected boolean isMarkReadOnly() {
        return true;
    }

    public Comparable getTypeSortKey() {
        String extension = PsiFileNode.extension((PsiFile)this.getValue());
        return extension == null ? null : new ExtensionSortKey(extension);
    }

    @Nullable
    public static String extension(@Nullable PsiFile file2) {
        VirtualFile vFile;
        if (file2 != null && (vFile = file2.getVirtualFile()) != null) {
            return vFile.getFileType().getDefaultExtension();
        }
        return null;
    }

    public boolean shouldDrillDownOnEmptyElement() {
        PsiFile file2 = (PsiFile)this.getValue();
        return file2 != null && file2.getFileType() == StdFileTypes.JAVA;
    }

    public boolean canRepresent(Object element) {
        if (super.canRepresent(element)) {
            return true;
        }
        PsiFile value = (PsiFile)this.getValue();
        return value != null && element != null && element.equals(value.getVirtualFile());
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/projectView/impl/nodes/PsiFileNode", "contains"));
        }
        return super.contains(file2) || this.isArchive() && Comparing.equal((Object)PathUtil.getLocalFile((VirtualFile)file2), (Object)this.getVirtualFile());
    }

    public static class ExtensionSortKey
    implements Comparable {
        private final String myExtension;

        public ExtensionSortKey(String extension) {
            this.myExtension = extension;
        }

        public int compareTo(Object o) {
            if (!(o instanceof ExtensionSortKey)) {
                return 0;
            }
            ExtensionSortKey rhs = (ExtensionSortKey)o;
            return this.myExtension.compareTo(rhs.myExtension);
        }
    }
}

