/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LRUPopupBuilder<T> {
    private static final int MAX_VISIBLE_SIZE = 20;
    private static final int LRU_ITEMS = 4;
    private final String myTitle;
    private final PropertiesComponent myPropertiesComponent;
    private final Map<T, Pair<String, Icon>> myPresentations;
    private T mySelection;
    private Consumer<T> myOnChosen;
    private Comparator<? super T> myComparator;
    private Iterable<? extends T> myItemsIterable;
    private JBIterable<T> myExtraItems;

    @NotNull
    public static ListPopup forFileLanguages(@NotNull Project project2, final @NotNull Iterable<VirtualFile> files, final @NotNull PerFileMappings<Language> mappings) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/LRUPopupBuilder", "forFileLanguages"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/ide/scratch/LRUPopupBuilder", "forFileLanguages"));
        }
        if (mappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/intellij/ide/scratch/LRUPopupBuilder", "forFileLanguages"));
        }
        ListPopup listPopup = LRUPopupBuilder.forFileLanguages(project2, null, new Consumer<Language>(){

            public void consume(Language t) {
                for (VirtualFile file2 : files) {
                    mappings.setMapping(file2, (Object)t);
                }
            }
        });
        if (listPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/LRUPopupBuilder", "forFileLanguages"));
        }
        return listPopup;
    }

    @NotNull
    public static ListPopup forFileLanguages(@NotNull Project project2, @Nullable Language selection, @NotNull Consumer<Language> onChosen) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/LRUPopupBuilder", "forFileLanguages"));
        }
        if (onChosen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onChosen", "com/intellij/ide/scratch/LRUPopupBuilder", "forFileLanguages"));
        }
        ListPopup listPopup = LRUPopupBuilder.languagePopupBuilder(project2, "Languages").forValues(LanguageUtil.getFileLanguages()).withSelection(selection).onChosen(onChosen).buildPopup();
        if (listPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/LRUPopupBuilder", "forFileLanguages"));
        }
        return listPopup;
    }

    @NotNull
    public static LRUPopupBuilder<Language> languagePopupBuilder(@NotNull Project project2, @NotNull String title) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/LRUPopupBuilder", "languagePopupBuilder"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/ide/scratch/LRUPopupBuilder", "languagePopupBuilder"));
        }
        LRUPopupBuilder<Language> lRUPopupBuilder = new LRUPopupBuilder<Language>(project2, title){

            @Override
            public String getDisplayName(Language language) {
                return language.getDisplayName();
            }

            @Override
            public Icon getIcon(Language language) {
                LanguageFileType associatedLanguage = language.getAssociatedFileType();
                return associatedLanguage != null ? associatedLanguage.getIcon() : null;
            }

            @Override
            public String getStorageId(Language language) {
                return language.getID();
            }
        }.withComparator(LanguageUtil.LANGUAGE_COMPARATOR);
        if (lRUPopupBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/LRUPopupBuilder", "languagePopupBuilder"));
        }
        return lRUPopupBuilder;
    }

    protected LRUPopupBuilder(@NotNull Project project2, @NotNull String title) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/LRUPopupBuilder", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/ide/scratch/LRUPopupBuilder", "<init>"));
        }
        this.myPresentations = ContainerUtil.newIdentityHashMap();
        this.myExtraItems = JBIterable.empty();
        this.myTitle = title;
        this.myPropertiesComponent = PropertiesComponent.getInstance((Project)project2);
    }

    public abstract String getDisplayName(T var1);

    public abstract String getStorageId(T var1);

    public abstract Icon getIcon(T var1);

    public LRUPopupBuilder<T> forValues(@Nullable Iterable<? extends T> items) {
        this.myItemsIterable = items;
        return this;
    }

    public LRUPopupBuilder<T> withSelection(@Nullable T t) {
        this.mySelection = t;
        return this;
    }

    public LRUPopupBuilder<T> withExtra(@NotNull T extra, @NotNull String displayName, @Nullable Icon icon) {
        if (extra == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extra", "com/intellij/ide/scratch/LRUPopupBuilder", "withExtra"));
        }
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/ide/scratch/LRUPopupBuilder", "withExtra"));
        }
        this.myExtraItems = this.myExtraItems.append(extra);
        this.myPresentations.put(extra, (Pair<String, Icon>)Pair.create((Object)displayName, (Object)icon));
        return this;
    }

    public LRUPopupBuilder<T> onChosen(@Nullable Consumer<T> consumer) {
        this.myOnChosen = consumer;
        return this;
    }

    public LRUPopupBuilder<T> withComparator(@Nullable Comparator<? super T> comparator2) {
        this.myComparator = comparator2;
        return this;
    }

    @NotNull
    public ListPopup buildPopup() {
        final ArrayList ids = ContainerUtil.newArrayList((Object[])this.restoreLRUItems());
        if (this.mySelection != null) {
            ids.add(this.getStorageId(this.mySelection));
        }
        ArrayList lru = ContainerUtil.newArrayListWithCapacity((int)4);
        ArrayList items = ContainerUtil.newArrayListWithCapacity((int)20);
        final List extra = this.myExtraItems.toList();
        for (T t : this.myItemsIterable) {
            (ContainerUtil.indexOf((List)ids, (Object)this.getStorageId(t)) != -1 ? lru : items).add(t);
        }
        if (this.myComparator != null) {
            Collections.sort(items, this.myComparator);
        }
        if (!lru.isEmpty()) {
            Collections.sort(lru, new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    return ContainerUtil.indexOf((List)ids, (Object)LRUPopupBuilder.this.getStorageId(o1)) - ContainerUtil.indexOf((List)ids, (Object)LRUPopupBuilder.this.getStorageId(o2));
                }
            });
        }
        final Object separator1 = !lru.isEmpty() && !items.isEmpty() ? items.get(0) : null;
        final Object separator2 = !lru.isEmpty() || !items.isEmpty() ? ContainerUtil.getFirstItem((List)extra) : null;
        List combinedItems = ContainerUtil.concat((List[])new List[]{lru, items, extra});
        BaseListPopupStep step = new BaseListPopupStep<T>(this.myTitle, combinedItems){

            @NotNull
            public String getTextFor(@NotNull T t) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/ide/scratch/LRUPopupBuilder$4", "getTextFor"));
                }
                String string = (String)((LRUPopupBuilder)LRUPopupBuilder.this).getPresentation(t).first;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/LRUPopupBuilder$4", "getTextFor"));
                }
                return string;
            }

            public Icon getIconFor(@NotNull T t) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/ide/scratch/LRUPopupBuilder$4", "getIconFor"));
                }
                return (Icon)((LRUPopupBuilder)LRUPopupBuilder.this).getPresentation(t).second;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public PopupStep onChosen(final T t, boolean finalChoice) {
                if (!extra.contains(t)) {
                    LRUPopupBuilder.this.storeLRUItems(t);
                }
                if (LRUPopupBuilder.this.myOnChosen != null) {
                    EdtInvocationManager.getInstance().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LRUPopupBuilder.this.myOnChosen.consume(t);
                        }
                    });
                }
                return null;
            }

            @Nullable
            public ListSeparator getSeparatorAbove(T value) {
                return value == separator1 || value == separator2 ? new ListSeparator() : null;
            }
        };
        int selection = Math.max(0, this.mySelection != null ? combinedItems.indexOf(this.mySelection) : 0);
        step.setDefaultOptionIndex(selection);
        ListPopup listPopup = LRUPopupBuilder.tweakSizeToPreferred(JBPopupFactory.getInstance().createListPopup((ListPopupStep)step));
        if (listPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/LRUPopupBuilder", "buildPopup"));
        }
        return listPopup;
    }

    @NotNull
    private Pair<String, Icon> getPresentation(T t) {
        Pair p = this.myPresentations.get(t);
        if (p == null) {
            p = Pair.create((Object)this.getDisplayName(t), (Object)this.getIcon(t));
            this.myPresentations.put(t, (Pair<String, Icon>)p);
        }
        Pair pair = p;
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/LRUPopupBuilder", "getPresentation"));
        }
        return pair;
    }

    @NotNull
    private static ListPopup tweakSizeToPreferred(@NotNull ListPopup popup) {
        if (popup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/ide/scratch/LRUPopupBuilder", "tweakSizeToPreferred"));
        }
        int nameLen = 0;
        ListPopupStep step = popup.getListStep();
        List values = step.getValues();
        for (Object v : values) {
            nameLen = Math.max(nameLen, step.getTextFor(v).length());
        }
        if (values.size() > 20) {
            Dimension size = new JLabel(StringUtil.repeatSymbol((char)'a', (int)nameLen), EmptyIcon.ICON_16, 2).getPreferredSize();
            size.width += 20;
            size.height *= 20;
            popup.setSize(size);
        }
        ListPopup listPopup = popup;
        if (listPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/LRUPopupBuilder", "tweakSizeToPreferred"));
        }
        return listPopup;
    }

    @NotNull
    private String[] restoreLRUItems() {
        String[] stringArray = (String[])ObjectUtils.notNull((Object)this.myPropertiesComponent.getValues(this.getLRUKey()), (Object)ArrayUtil.EMPTY_STRING_ARRAY);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/LRUPopupBuilder", "restoreLRUItems"));
        }
        return stringArray;
    }

    private void storeLRUItems(@NotNull T t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/ide/scratch/LRUPopupBuilder", "storeLRUItems"));
        }
        String[] values = this.myPropertiesComponent.getValues(this.getLRUKey());
        ArrayList lastUsed = ContainerUtil.newArrayListWithCapacity((int)4);
        lastUsed.add(this.getStorageId(t));
        if (values != null) {
            for (String value : values) {
                if (!lastUsed.contains(value)) {
                    lastUsed.add(value);
                }
                if (lastUsed.size() == 4) break;
            }
        }
        this.myPropertiesComponent.setValues(this.getLRUKey(), ArrayUtil.toStringArray((Collection)lastUsed));
    }

    @NotNull
    private String getLRUKey() {
        String string = this.getClass().getName() + "/" + this.myTitle;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/LRUPopupBuilder", "getLRUKey"));
        }
        return string;
    }
}

