/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.structureView.impl.java.PsiMethodTreeElement;
import com.intellij.ide.structureView.impl.java.SuperTypeGroup;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SuperTypesGrouper
implements Grouper {
    public static final Key<WeakReference<PsiMethod>> SUPER_METHOD_KEY = Key.create((String)"StructureTreeBuilder.SUPER_METHOD_KEY");
    @NonNls
    public static final String ID = "SHOW_INTERFACES";

    @NotNull
    public Collection<Group> group(@NotNull AbstractTreeNode parent, @NotNull Collection<TreeElement> children2) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/ide/structureView/impl/java/SuperTypesGrouper", "group"));
        }
        if (children2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/ide/structureView/impl/java/SuperTypesGrouper", "group"));
        }
        if (SuperTypesGrouper.isParentGrouped(parent)) {
            List<Group> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/SuperTypesGrouper", "group"));
            }
            return list;
        }
        THashMap groups = new THashMap();
        for (TreeElement child : children2) {
            if (!(child instanceof PsiMethodTreeElement)) continue;
            PsiMethodTreeElement element = (PsiMethodTreeElement)child;
            PsiMethod method = ((PsiMethodTreeElement)child).getMethod();
            if (element.isInherited()) {
                PsiClass groupClass = method.getContainingClass();
                SuperTypeGroup group = SuperTypesGrouper.getOrCreateGroup(groupClass, SuperTypeGroup.OwnershipType.INHERITS, (Map<Group, SuperTypeGroup>)groups);
                group.addMethod(child);
                continue;
            }
            Object[] superMethods = method.findSuperMethods();
            if (superMethods.length <= 0) continue;
            for (int i = 1; i < superMethods.length; ++i) {
                PsiMethod superMethod = superMethods[i];
                PsiClass containingClass = superMethod.getContainingClass();
                if (containingClass == null || !containingClass.isInterface()) continue;
                ArrayUtil.swap((Object[])superMethods, (int)0, (int)i);
                break;
            }
            PsiMethod superMethod = superMethods[0];
            method.putUserData(SUPER_METHOD_KEY, new WeakReference<PsiMethod>(superMethod));
            PsiClass groupClass = superMethod.getContainingClass();
            boolean overrides = SuperTypesGrouper.methodOverridesSuper(method, superMethod);
            SuperTypeGroup.OwnershipType ownershipType = overrides ? SuperTypeGroup.OwnershipType.OVERRIDES : SuperTypeGroup.OwnershipType.IMPLEMENTS;
            SuperTypeGroup group = SuperTypesGrouper.getOrCreateGroup(groupClass, ownershipType, (Map<Group, SuperTypeGroup>)groups);
            group.addMethod(child);
        }
        Set<Group> set = groups.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/SuperTypesGrouper", "group"));
        }
        return set;
    }

    private static SuperTypeGroup getOrCreateGroup(PsiClass groupClass, SuperTypeGroup.OwnershipType ownershipType, Map<Group, SuperTypeGroup> groups) {
        SuperTypeGroup superTypeGroup = new SuperTypeGroup(groupClass, ownershipType);
        SuperTypeGroup existing = groups.get(superTypeGroup);
        if (existing == null) {
            groups.put(superTypeGroup, superTypeGroup);
            existing = superTypeGroup;
        }
        return existing;
    }

    private static boolean isParentGrouped(AbstractTreeNode parent) {
        while (parent != null) {
            if (parent.getValue() instanceof SuperTypeGroup) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private static boolean methodOverridesSuper(PsiMethod method, PsiMethod superMethod) {
        boolean overrides = false;
        if (method.hasModifierProperty("abstract")) {
            overrides = true;
        } else if (!superMethod.hasModifierProperty("abstract")) {
            overrides = true;
        }
        return overrides;
    }

    @NotNull
    public ActionPresentation getPresentation() {
        ActionPresentationData actionPresentationData = new ActionPresentationData(IdeBundle.message((String)"action.structureview.group.methods.by.defining.type", (Object[])new Object[0]), null, AllIcons.General.ImplementingMethod);
        if (actionPresentationData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/SuperTypesGrouper", "getPresentation"));
        }
        return actionPresentationData;
    }

    @NotNull
    public String getName() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/SuperTypesGrouper", "getName"));
        }
        return ID;
    }
}

