/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.TodoTreeStructure;
import com.intellij.ide.todo.nodes.ToDoRootNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.Collection;

public class ChangeListTodosTreeStructure
extends TodoTreeStructure {
    public ChangeListTodosTreeStructure(Project project2) {
        super(project2);
    }

    @Override
    public boolean accept(PsiFile psiFile) {
        if (!psiFile.isValid()) {
            return false;
        }
        boolean isAffected = false;
        Collection changes = ChangeListManager.getInstance((Project)this.myProject).getDefaultChangeList().getChanges();
        for (Change change : changes) {
            if (!change.affectsFile(VfsUtil.virtualToIoFile((VirtualFile)psiFile.getVirtualFile()))) continue;
            isAffected = true;
            break;
        }
        return isAffected && (this.myTodoFilter != null && this.myTodoFilter.accept(this.mySearchHelper, psiFile) || this.myTodoFilter == null && this.mySearchHelper.getTodoItemsCount(psiFile) > 0);
    }

    @Override
    public boolean getIsPackagesShown() {
        return this.myArePackagesShown;
    }

    @Override
    Object getFirstSelectableElement() {
        return ((ToDoRootNode)this.myRootElement).getSummaryNode();
    }

    @Override
    protected AbstractTreeNode createRootElement() {
        return new ToDoRootNode(this.myProject, new Object(), this.myBuilder, this.mySummaryElement);
    }
}

